/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodType;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.ItemLib;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FishSpider
extends FishSpecies {
    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-5, 20};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 15;
    }

    @Override
    public int getFertility() {
        return 4500;
    }

    @Override
    public int getWaterRequired() {
        return 30;
    }

    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN ? 5 : 0;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(ItemLib.dropletWater, 2.0);
        this.addProduct(ItemLib.string, 4.0);
        this.addProduct(ItemLib.spiderEye, 2.5);
    }

    @Override
    public double getFishOilVolume() {
        return 1.35;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(ItemLib.fermentedEye);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 12;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300, 1, true));
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 1, true));
        }
    }

    @Override
    public boolean canWorkAtThisTime(boolean isDay) {
        return !isDay;
    }

    @Override
    public RodType getRodNeeded() {
        return RodType.OLD;
    }

    @Override
    public double getCatchChance(World world, int height) {
        return Environment.Height.isCave(height) || world.func_72935_r() ? 25.0 : 0.0;
    }

    @Override
    public double getCaughtAliveChance(World world, int height) {
        return Environment.Height.isCave(height) ? 75.0 : 0.0;
    }
}

