/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.gui;

import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.Text;
import mariculture.core.gui.GuiStorage;
import mariculture.core.gui.InventoryStorage;
import mariculture.core.gui.feature.FeatureScanner;
import mariculture.fishery.Fish;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiScanner
extends GuiStorage {
    private ItemStack drop;
    private ItemStack fish;

    public GuiScanner(IInventory playerInv, InventoryStorage storage, World world, String gui) {
        super(playerInv, storage, world, gui, 30);
        this.features.add(new FeatureScanner());
        this.nameHeight = -9;
    }

    @Override
    public int getX() {
        return 90;
    }

    @Override
    public String getName() {
        return "";
    }

    private void drawText(String str, int x, int z) {
        this.field_146289_q.func_78276_b(str, x, z, 0x404040);
    }

    private String getBoolean(int i) {
        return i == 0 ? Text.localize("fish.data.false") : Text.localize("fish.data.true");
    }

    @Override
    public void drawForeground() {
        this.fish = this.storage.func_70301_a(0);
        if (this.fish == null || !this.fish.func_77942_o() || Fishing.fishHelper.isEgg(this.fish)) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)0.675f, (float)0.675f, (float)0.675f);
        GL11.glTranslatef((float)-5.0f, (float)5.0f, (float)0.0f);
        FishSpecies active = FishSpecies.species.get(Fish.species.getDNA(this.fish));
        FishSpecies inactive = FishSpecies.species.get(Fish.species.getLowerDNA(this.fish));
        String activeSpecies = active.isDominant() ? "\u00a76" + active.getName() : "\u00a79" + active.getName();
        String inactiveSpecies = inactive.isDominant() ? "\u00a76" + inactive.getName() : "\u00a79" + inactive.getName();
        String[] lifespan = Fish.lifespan.getScannedDisplay(this.fish);
        String[] fertility = Fish.fertility.getScannedDisplay(this.fish);
        String[] production = Fish.production.getScannedDisplay(this.fish);
        String[] foodUsage = Fish.foodUsage.getScannedDisplay(this.fish);
        String[] tankSize = Fish.tankSize.getScannedDisplay(this.fish);
        String[] up = Fish.up.getScannedDisplay(this.fish);
        String[] down = Fish.down.getScannedDisplay(this.fish);
        String[] north = Fish.north.getScannedDisplay(this.fish);
        String[] east = Fish.east.getScannedDisplay(this.fish);
        String[] south = Fish.south.getScannedDisplay(this.fish);
        String[] west = Fish.west.getScannedDisplay(this.fish);
        this.drawText(Text.localize("fish.data.species"), -75, 19);
        this.drawText(lifespan[0], -75, 29);
        this.drawText(fertility[0], -75, 39);
        this.drawText(production[0], -75, 49);
        this.drawText(foodUsage[0], -75, 59);
        this.drawText(tankSize[0], -75, 69);
        this.drawText(up[0], -75, 79);
        this.drawText(down[0], -75, 89);
        this.drawText(north[0], -75, 99);
        this.drawText(east[0], -75, 109);
        this.drawText(south[0], -75, 119);
        this.drawText(west[0], -75, 129);
        this.drawText("\u00a7lActive", 20, 10);
        this.drawText(activeSpecies, 20, 20);
        this.drawText(lifespan[1], 20, 30);
        this.drawText(fertility[1], 20, 40);
        this.drawText(production[1], 20, 50);
        this.drawText(foodUsage[1], 20, 60);
        this.drawText(tankSize[1], 20, 70);
        this.drawText(up[1], 20, 80);
        this.drawText(down[1], 20, 90);
        this.drawText(north[1], 20, 100);
        this.drawText(east[1], 20, 110);
        this.drawText(south[1], 20, 120);
        this.drawText(west[1], 20, 130);
        this.drawText("\u00a7lInactive", 140, 10);
        this.drawText(inactiveSpecies, 140, 20);
        this.drawText(lifespan[2], 140, 30);
        this.drawText(fertility[2], 140, 40);
        this.drawText(production[2], 140, 50);
        this.drawText(foodUsage[2], 140, 60);
        this.drawText(tankSize[2], 140, 70);
        this.drawText(up[2], 140, 80);
        this.drawText(down[2], 140, 90);
        this.drawText(north[2], 140, 100);
        this.drawText(east[2], 140, 110);
        this.drawText(south[2], 140, 120);
        this.drawText(west[2], 140, 130);
        GL11.glPopMatrix();
    }
}

