/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.tile;

import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.IIncubator;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.network.PacketHandler;
import mariculture.core.network.PacketParticle;
import mariculture.core.tile.base.TileStorage;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileHatchery
extends TileStorage
implements ISidedInventory,
IIncubator {
    protected static final int MAX = MachineSpeeds.getHatcherySpeed();
    public static final int[] IN = new int[]{0};
    public static final int[] OUT = new int[]{1, 2};
    private boolean isInit = false;
    private boolean canWork;
    private int processed;

    public TileHatchery() {
        this.inventory = new ItemStack[3];
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void onInventoryChange(int slot) {
        this.updateCanWork();
        PacketHandler.syncInventory(this, this.getInventory());
    }

    public int[] func_94128_d(int side) {
        return side != ForgeDirection.DOWN.ordinal() ? IN : OUT;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.inventory[0] == null && stack.field_77994_a == 1 && side != ForgeDirection.DOWN.ordinal();
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return side == ForgeDirection.DOWN.ordinal() && slot > 0;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public boolean onTick(int i) {
        return this.field_145850_b.func_72820_D() % (long)i == 0L;
    }

    private void updateCanWork() {
        this.canWork = this.inventory[0] != null && Fishing.fishHelper.isEgg(this.inventory[0]) && (this.inventory[1] == null || this.inventory[2] == null);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isInit) {
                this.isInit = true;
                this.updateCanWork();
            }
            if (this.canWork) {
                if (this.onTick(20)) {
                    PacketHandler.sendAround(new PacketParticle(PacketParticle.Particle.SPLASH, 8, this.field_145851_c, (double)this.field_145848_d - 0.05, this.field_145849_e), this);
                }
                ++this.processed;
                if (this.processed >= MAX) {
                    this.inventory[0] = Fishing.fishHelper.attemptToHatchEgg(this.inventory[0], this.field_145850_b.field_73012_v, 1.0, this);
                    this.updateCanWork();
                    this.processed = 0;
                }
            } else {
                this.processed = 0;
            }
        }
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public int getBirthChanceBoost() {
        return 0;
    }

    @Override
    public void eject(ItemStack fish) {
        if (this.inventory[1] == null) {
            this.func_70299_a(1, fish);
        } else if (this.inventory[2] == null) {
            this.func_70299_a(2, fish);
        } else {
            SpawnItemHelper.spawnItem(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, fish);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.canWork = nbt.func_74767_n("CanWork");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("CanWork", this.canWork);
    }
}

