/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import mariculture.core.config.Enchantments;
import mariculture.core.helpers.ClientHelper;
import mariculture.core.helpers.EnchantHelper;
import mariculture.magic.Magic;
import mariculture.magic.MirrorSavedData;
import mariculture.magic.enchantments.EnchantmentFlight;
import mariculture.magic.enchantments.EnchantmentGlide;
import mariculture.magic.enchantments.EnchantmentJump;
import mariculture.magic.enchantments.EnchantmentSpeed;
import mariculture.magic.enchantments.EnchantmentSpider;
import mariculture.magic.enchantments.EnchantmentStepUp;
import mariculture.magic.jewelry.parts.JewelryMaterial;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class MirrorHelper {
    public static String world = "ls43llsds#232423d";
    public static HashMap<String, ItemStack[]> inventories = new HashMap();
    public static ItemStack[] inventory;
    public static HashMap<String, JewelryMaterial[]> materialList;
    public static JewelryMaterial[] materials;
    private static int updateTick;

    public static MirrorSavedData getData(EntityPlayer player) {
        return MirrorHelper.getData(player.field_70170_p, player.func_70005_c_());
    }

    public static MirrorSavedData getData(World world, String name) {
        String check = "Mariculture-Mirror-" + (Enchantments.Jewelry.JEWELRY_OFFLINE ? "PlayerOffline" : name);
        MirrorSavedData data = (MirrorSavedData)world.func_72943_a(MirrorSavedData.class, check);
        if (data == null) {
            data = new MirrorSavedData(check);
            world.func_72823_a(check, (WorldSavedData)data);
        }
        return data;
    }

    public static boolean isSameWorld(EntityPlayer player) {
        String check = player.field_70170_p.func_72912_H().func_76065_j();
        if (check.equals(world)) {
            return true;
        }
        world = check;
        return false;
    }

    public static JewelryMaterial[] getMaterials(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? MirrorHelper.getColorsForClient() : MirrorHelper.getColorsForPlayer(player);
    }

    public static JewelryMaterial[] getColorsForPlayer(EntityPlayer player) {
        String key = player.func_70005_c_();
        if (materialList.get(key) != null && MirrorHelper.isSameWorld(player)) {
            return materialList.get(key);
        }
        JewelryMaterial[] arr = MirrorHelper.fetchMaterials(player);
        materialList.put(key, arr);
        return arr;
    }

    @SideOnly(value=Side.CLIENT)
    private static JewelryMaterial[] getColorsForClient() {
        EntityPlayer player = ClientHelper.getPlayer();
        if (materials != null && MirrorHelper.isSameWorld(player)) {
            return materials;
        }
        materials = MirrorHelper.fetchMaterials(player);
        return materials;
    }

    private static JewelryMaterial[] fetchMaterials(EntityPlayer player) {
        ItemStack[] mirror;
        ArrayList<JewelryMaterial> array = new ArrayList<JewelryMaterial>();
        for (ItemStack element : mirror = MirrorHelper.getInventory(player)) {
            if (element == null || !element.func_77942_o()) continue;
            array.add(JewelryMaterial.list.get(element.field_77990_d.func_74779_i("material")));
        }
        return array.toArray(new JewelryMaterial[array.size()]);
    }

    public static ItemStack[] getInventory(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? MirrorHelper.getInventoryForClient() : MirrorHelper.getInventoryForPlayer(player);
    }

    public static ItemStack[] getInventoryForPlayer(EntityPlayer player) {
        if (inventories.get(player.func_70005_c_()) != null && MirrorHelper.isSameWorld(player)) {
            return inventories.get(player.func_70005_c_());
        }
        ItemStack[] contents = null;
        MirrorSavedData data = MirrorHelper.getData(player);
        contents = data.getJewelry() == null ? data.setJewelry(new ItemStack[4]) : data.getJewelry();
        inventories.put(player.func_70005_c_(), contents);
        return contents;
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack[] getInventoryForClient() {
        if (inventory != null && MirrorHelper.isSameWorld(ClientHelper.getPlayer())) {
            return inventory;
        }
        MirrorSavedData data = MirrorHelper.getData(ClientHelper.getPlayer());
        inventory = data.getJewelry() == null ? data.setJewelry(new ItemStack[4]) : data.getJewelry();
        return inventory;
    }

    public static boolean save(EntityPlayer player, ItemStack[] invent) {
        return player.field_70170_p.field_72995_K ? MirrorHelper.saveClient(ClientHelper.getPlayer(), invent) : MirrorHelper.saveServer(player, invent);
    }

    public static boolean saveClient(EntityPlayer player, ItemStack[] invent) {
        inventory = MirrorHelper.getData(player).setJewelry(invent);
        materials = null;
        if (EnchantHelper.exists(Magic.speed)) {
            EnchantmentSpeed.set(EnchantHelper.getEnchantStrength(Magic.speed, player));
        }
        if (EnchantHelper.exists(Magic.jump)) {
            EnchantmentJump.set(EnchantHelper.getEnchantStrength(Magic.jump, player));
        }
        if (EnchantHelper.exists(Magic.glide)) {
            EnchantmentGlide.set(EnchantHelper.getEnchantStrength(Magic.glide, player));
        }
        if (EnchantHelper.exists(Magic.spider)) {
            EnchantmentSpider.set(EnchantHelper.hasEnchantment(Magic.spider, player));
        }
        if (EnchantHelper.exists(Magic.flight)) {
            EnchantmentFlight.set(EnchantHelper.getEnchantStrength(Magic.flight, player), player);
        }
        if (EnchantHelper.exists(Magic.stepUp)) {
            EnchantmentStepUp.set(EnchantHelper.getEnchantStrength(Magic.stepUp, player), player);
        }
        return true;
    }

    public static boolean saveServer(EntityPlayer player, ItemStack[] invent) {
        String key = player.func_70005_c_();
        inventories.put(key, MirrorHelper.getData(player).setJewelry(invent));
        if (materialList.containsKey(key)) {
            materialList.remove(key);
        }
        return true;
    }

    static {
        materialList = new HashMap();
    }
}

