/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import mariculture.magic.JewelryHandler;
import mariculture.magic.ShapedJewelryRecipe;
import mariculture.magic.jewelry.ItemJewelry;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessJewelryRecipe
implements IRecipe {
    private ItemStack output = null;
    private ArrayList<Object> input = new ArrayList();

    public ShapelessJewelryRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessJewelryRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessJewelryRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    ShapelessJewelryRecipe(ShapelessRecipes recipe, Map<ItemStack, String> replacements) {
        this.output = recipe.func_77571_b();
        Iterator i$ = recipe.field_77579_b.iterator();
        while (i$.hasNext()) {
            ItemStack ingred;
            Object finalObj = ingred = (ItemStack)i$.next();
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingred, (boolean)false)) continue;
                finalObj = OreDictionary.getOres((String)replace.getValue());
                break;
            }
            this.input.add(finalObj);
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting craft) {
        ItemStack ret = this.output.func_77946_l();
        if (!ret.func_77942_o()) {
            ret.func_77982_d(new NBTTagCompound());
        }
        ArrayList<ShapedJewelryRecipe.LinkedInteger> cache = new ArrayList<ShapedJewelryRecipe.LinkedInteger>();
        for (int j = 0; j < craft.func_70302_i_(); ++j) {
            ItemStack stack = craft.func_70301_a(j);
            if (stack == null) continue;
            LinkedHashMap maps = (LinkedHashMap)EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Map.Entry i : maps.entrySet()) {
                Enchantment enchant = Enchantment.field_77331_b[(Integer)i.getKey()];
                cache.add(new ShapedJewelryRecipe.LinkedInteger(enchant.field_77352_x, EnchantmentHelper.func_77506_a((int)enchant.field_77352_x, (ItemStack)stack)));
            }
        }
        if (cache.size() > 0) {
            Collections.shuffle(cache);
            int[] level = new int[cache.size()];
            int[] enchant = new int[cache.size()];
            for (int i = 0; i < cache.size(); ++i) {
                enchant[i] = ((ShapedJewelryRecipe.LinkedInteger)cache.get((int)i)).enchant;
                level[i] = ((ShapedJewelryRecipe.LinkedInteger)cache.get((int)i)).level;
            }
            ret.field_77990_d.func_74783_a("EnchantmentList", enchant);
            ret.field_77990_d.func_74783_a("EnchantmentLevels", level);
        }
        return ret;
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = this.checkItemEquals((ItemStack)next, slot);
                } else if (next instanceof ArrayList) {
                    for (ItemStack item : (ArrayList)next) {
                        match = match || this.checkItemEquals(item, slot);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        if (target.func_77973_b() instanceof ItemJewelry) {
            return JewelryHandler.getBinding(target) == JewelryHandler.getBinding(input) && JewelryHandler.getMaterial(target) == JewelryHandler.getMaterial(input) && JewelryHandler.getType(target) == JewelryHandler.getType(input);
        }
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j());
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }
}

