/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic.jewelry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mariculture.api.core.MaricultureTab;
import mariculture.api.util.Text;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.items.ItemDamageable;
import mariculture.magic.JewelryHandler;
import mariculture.magic.Magic;
import mariculture.magic.jewelry.parts.JewelryBinding;
import mariculture.magic.jewelry.parts.JewelryMaterial;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;

public abstract class ItemJewelry
extends ItemDamageable {
    public static final HashMap<String, IIcon> specials = new HashMap();

    public ItemJewelry() {
        super(100);
        this.setNoRepair();
        this.func_77637_a(MaricultureTab.tabMagic);
    }

    public abstract JewelryType getType();

    public abstract int getMaxDurability();

    public abstract boolean renderBinding();

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return 3;
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            JewelryMaterial material = JewelryHandler.getMaterial(stack);
            if (material == Magic.dummyMaterial) {
                return Text.translate("oneRing");
            }
            return material.getColor() + material.getCraftingItem(this.getType()).func_82833_r() + " " + Text.localize(this.func_77667_c(stack) + ".name");
        }
        return Text.localize(this.func_77667_c(stack));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (stack.func_77942_o()) {
            JewelryType type = this.getType();
            JewelryMaterial material = JewelryHandler.getMaterial(stack);
            JewelryBinding binding = JewelryHandler.getBinding(stack);
            list.add(binding.getColor() + StatCollector.func_74838_a((String)"mariculture.string.with") + " " + binding.getCraftingItem(this.getType()).func_82833_r());
            if (player.field_70170_p.field_72995_K && material != Magic.dummyMaterial) {
                if (Keyboard.isKeyDown((int)42)) {
                    list.add("\u00a79" + Text.translate("stats.jewelry"));
                    list.add(Text.translate("elemental") + ": " + Text.translate("elemental." + material.getIdentifier().toLowerCase()));
                    list.add(Text.translate("max.enchants") + ": " + (type.getMaximumEnchantments() + material.getExtraEnchantments(type)));
                    list.add(Text.translate("max.level") + ": " + Math.min(binding.getMaxEnchantmentLevel(type), material.getMaximumEnchantmentLevel(type)));
                    list.add(Text.translate("max.damage") + ": " + this.getMaxDamage(stack));
                } else {
                    list.add(Text.getShiftText("jewelry"));
                }
            }
        }
        if (EnchantHelper.getLevel(Magic.oneRing, stack) > 0) {
            list.add(" ");
            list.add(StatCollector.func_74838_a((String)"enchantment.oneRing.line1"));
            list.add(StatCollector.func_74838_a((String)"enchantment.oneRing.line2"));
            list.add(StatCollector.func_74838_a((String)"enchantment.oneRing.line3"));
            list.add(StatCollector.func_74838_a((String)"enchantment.oneRing.line4"));
            list.add(" ");
        }
    }

    public int getMaxDamage(ItemStack stack) {
        if (stack.func_77942_o()) {
            return (int)((float)JewelryHandler.getBinding(stack).getDurabilityBase(this.getType()) * JewelryHandler.getMaterial(stack).getDurabilityModifier(this.getType()));
        }
        return this.func_77612_l();
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (stack.func_77942_o()) {
            if (pass == 0) {
                JewelryBinding binding;
                if (this.renderBinding() && (binding = JewelryHandler.getBinding(stack)) != null && !binding.ignore) {
                    return binding.getIcon(this.getType());
                }
            } else if (pass == 1) {
                JewelryMaterial material = JewelryHandler.getMaterial(stack);
                if (material != null && !material.ignore) {
                    return material.getIcon(this.getType());
                }
            } else if (stack.field_77990_d.func_74764_b("Specials")) {
                return specials.get(stack.field_77990_d.func_74779_i("Specials"));
            }
        }
        return this.field_77791_bV;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        if (this.renderBinding()) {
            for (Map.Entry<String, Object> entry : JewelryBinding.list.entrySet()) {
                if (((JewelryBinding)entry.getValue()).ignore) continue;
                ((JewelryBinding)entry.getValue()).registerIcons(iconRegister, this.getType());
            }
        }
        for (Map.Entry<String, Object> entry : JewelryMaterial.list.entrySet()) {
            if (((JewelryMaterial)entry.getValue()).ignore) continue;
            ((JewelryMaterial)entry.getValue()).registerIcons(iconRegister, this.getType());
        }
        this.field_77791_bV = iconRegister.func_94245_a("mariculture:jewelry/blank");
        specials.put("\u00a7eOne Ring", iconRegister.func_94245_a("mariculture:jewelry/ring/oneRing"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Map.Entry<String, JewelryBinding> binding : JewelryBinding.list.entrySet()) {
            if (binding.getValue().ignore) continue;
            for (Map.Entry<String, JewelryMaterial> material : JewelryMaterial.list.entrySet()) {
                if (material.getValue().ignore) continue;
                list.add(JewelryHandler.createJewelry((ItemJewelry)item, binding.getValue(), material.getValue()));
            }
        }
        ItemStack stack = JewelryHandler.createSpecial((ItemJewelry)item, JewelryType.RING, "\u00a7eOne Ring");
        if (stack != null && EnchantHelper.exists(Magic.oneRing)) {
            stack.func_77966_a(Magic.oneRing, 1);
            list.add(stack);
        }
    }

    public static enum JewelryType {
        RING(1),
        BRACELET(3),
        NECKLACE(7),
        NONE(0);

        public final int max;

        private JewelryType(int max) {
            this.max = max;
        }

        public int getMaximumEnchantments() {
            return this.max;
        }
    }
}

