/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.Text;
import mariculture.core.Core;
import mariculture.core.handlers.LogHandler;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.lib.ItemLib;
import mariculture.core.lib.Modules;
import mariculture.core.util.Fluids;
import mariculture.core.util.RecipeItem;
import mariculture.fishery.Fishery;
import mariculture.plugins.Plugins;
import mariculture.world.WorldPlus;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Level;

public class PluginForestry
extends Plugins.Plugin {
    public static AquaBackpack backpack;
    public static Item aquaBackpackT1;
    public static Item aquaBackpackT2;

    public PluginForestry(String name) {
        super(name);
    }

    @Override
    public void preInit() {
        Fluids.add("bioethanol", FluidRegistry.getFluid((String)"bioethanol"), 1000, true);
        backpack = new AquaBackpack();
        aquaBackpackT1 = BackpackManager.backpackInterface.addBackpack((IBackpackDefinition)backpack, EnumBackpackType.T1);
        aquaBackpackT2 = BackpackManager.backpackInterface.addBackpack((IBackpackDefinition)backpack, EnumBackpackType.T2);
        GameRegistry.registerItem((Item)aquaBackpackT1, (String)"aquaBackpackT1");
        GameRegistry.registerItem((Item)aquaBackpackT2, (String)"aquaBackpackT2");
    }

    public void addBee(String str, int num) {
        try {
            ItemStack bee = new ItemStack(GameRegistry.findItem((String)"Forestry", (String)str));
            if (bee != null) {
                RecipeHelper.addShapeless(new ItemStack(Fishery.bait, num, 4), new Object[]{bee});
            }
        }
        catch (Exception e) {
            LogHandler.log(Level.INFO, "Mariculture failed to add forestry bees, as convertible to bee bait");
        }
    }

    @Override
    public void init() {
        backpack.addValidItem(ItemLib.oyster);
        backpack.addValidItem(ItemLib.ink);
        backpack.addValidItem(ItemLib.pearls);
        backpack.addValidItem(ItemLib.fish);
        backpack.addValidItem(new ItemStack(ItemLib.lily));
        if (Modules.isActive(Modules.fishery)) {
            this.addBee("beeDroneGE", 1);
            this.addBee("beePrincessGE", 5);
            this.addBee("beeQueenGE", 7);
            backpack.addValidItem(ItemLib.fishMeal);
            backpack.addValidItem(new ItemStack(Fishery.net));
            backpack.addValidItem(new ItemStack(Fishery.fishy));
            backpack.addValidItem(new ItemStack(Fishery.bait, 1, Short.MAX_VALUE));
            for (int i = 0; i < 12; ++i) {
                backpack.addValidItem(new ItemStack(Core.materials, 1, i));
            }
            FuelManager.bronzeEngineFuel.put(Fluids.getFluid("fish_oil"), new EngineBronzeFuel(Fluids.getFluid("fish_oil"), 1, 7500, 1));
            for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
                FishSpecies fish = species.getValue();
                if (!(fish.getFishOilVolume() > 0.0) || fish.getLiquifiedProduct() == null || fish.getLiquifiedProductChance() <= 0) continue;
                RecipeManagers.squeezerManager.addRecipe(fish.getLifeSpan(), new ItemStack[]{new ItemStack(ItemLib.vanillaFish, 1, fish.getID())}, Fluids.getFluidStack("fish_oil", (int)fish.getFishOilVolume() * 1000), fish.getLiquifiedProduct(), fish.getLiquifiedProductChance());
            }
        }
        RecipeHelper.addShaped(new ItemStack(aquaBackpackT1), new Object[]{"SWS", "FCF", "SWS", Character.valueOf('S'), ItemLib.string, Character.valueOf('W'), ItemLib.wool, Character.valueOf('F'), "fish", Character.valueOf('C'), ItemLib.chest});
        if (Modules.isActive(Modules.worldplus)) {
            backpack.addValidItem(new ItemStack(WorldPlus.plantGrowable, 1, Short.MAX_VALUE));
            backpack.addValidItem(new ItemStack(WorldPlus.plantStatic, 1, Short.MAX_VALUE));
            FuelManager.fermenterFuel.put(new ItemStack(WorldPlus.plantStatic, 1, 1), new FermenterFuel(new ItemStack(WorldPlus.plantStatic, 1, 1), 150, 1));
        }
        try {
            ItemStack crafting = new ItemStack(GameRegistry.findItem((String)"Forestry", (String)"craftingMaterial"), 1, 3);
            RecipeManagers.carpenterManager.addRecipe(200, FluidRegistry.getFluidStack((String)"water", (int)1000), null, new ItemStack(aquaBackpackT2), new Object[]{"WDW", "WTW", "WWW", Character.valueOf('D'), ItemLib.diamond, Character.valueOf('W'), crafting, Character.valueOf('T'), aquaBackpackT1});
        }
        catch (Exception e) {
            LogHandler.log(Level.INFO, "Mariculture was unsuccesful at adding the recipe for the woven aquatic backpack");
        }
    }

    @Override
    public void postInit() {
    }

    public class AquaBackpack
    implements IBackpackDefinition {
        private ArrayList<ItemStack> items = new ArrayList();

        public String getKey() {
            return "AQUA";
        }

        public String getName() {
            return Text.localize("item.aquaBackpack.name");
        }

        public int getPrimaryColour() {
            return 0x41A4A1;
        }

        public int getSecondaryColour() {
            return 1736058;
        }

        public void addValidItem(ItemStack validItem) {
            if (!this.items.contains(validItem)) {
                this.items.add(validItem);
            }
        }

        public Collection<ItemStack> getValidItems(EntityPlayer player) {
            return this.items;
        }

        public boolean isValidItem(EntityPlayer player, ItemStack itemstack) {
            for (ItemStack stack : this.items) {
                if (!RecipeItem.equals(itemstack, stack)) continue;
                return true;
            }
            return false;
        }
    }
}

