/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Map;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.Core;
import mariculture.core.RecipesSmelting;
import mariculture.core.blocks.BlockAir;
import mariculture.core.handlers.LogHandler;
import mariculture.core.lib.ItemLib;
import mariculture.core.lib.MetalRates;
import mariculture.core.util.Fluids;
import mariculture.plugins.Plugins;
import mariculture.plugins.tconstruct.ModPearl;
import mariculture.plugins.tconstruct.TitaniumTools;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.tools.ToolCore;

public class PluginTConstruct
extends Plugins.Plugin {
    public PluginTConstruct(String name) {
        super(name);
    }

    @Override
    public void preInit() {
        try {
            for (Map.Entry entry : FluidType.fluidTypes.entrySet()) {
                Fluids.add(((String)entry.getKey()).toLowerCase(), ((FluidType)entry.getValue()).fluid, 144);
            }
            Fluids.add("ender", FluidType.getFluidType((String)"Ender").fluid, 25, true);
            Fluids.add("blood", FluidRegistry.getFluid((String)"blood"), 10, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogHandler.log(Level.INFO, "Mariculture failed to sync up with TiC Fluids");
        }
        TitaniumTools.preInit();
    }

    @Override
    public void init() {
        ItemStack stack = new ItemStack(ItemLib.stone);
        ItemStack rack = new ItemStack(Blocks.field_150424_aL);
        RecipesSmelting.addMetal(Fluids.getFluidName("aluminumbrass"), "AluminumBrass", 940, stack, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("obsidian"), "Obsidian", 1000, stack, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("cobalt"), "Cobalt", 1495, rack, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("ardite"), "Ardite", 1750, rack, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("manyullyn"), "Manyullyn", 1950, rack, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("alumite"), "Alumite", 387, stack, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("platinum"), "Platinum", 1768, stack, 2);
        RecipesSmelting.addMetal(Fluids.getFluidName("invar"), "Invar", 1427, stack, 2);
        Block torch = GameRegistry.findBlock((String)"TConstruct", (String)"decoration.stonetorch");
        if (torch != null) {
            BlockAir.flammables.add(torch);
        }
    }

    @Override
    public void postInit() {
        TitaniumTools.postInit();
        PluginTConstruct.addAlloy();
        PluginTConstruct.addModifiers();
        PluginTConstruct.addMelting();
    }

    public static void addMelting() {
        PluginTConstruct.addMelting(Core.limestone, 0, "blockLimestone", Fluids.getFluidStack("quicklime", 900), 250);
        PluginTConstruct.addMelting(Core.rocks, 3, "oreRutile", Fluids.getFluidStack("rutile", MetalRates.ORE), 800);
        PluginTConstruct.addMelting(Core.metals, 2, "dustRutile", Fluids.getFluidStack("rutile", MetalRates.INGOT), 800);
        PluginTConstruct.addMelting(Core.metals, 2, "ingotRutile", Fluids.getFluidStack("rutile", MetalRates.INGOT), 800);
        PluginTConstruct.addMelting(Core.metals, 2, "blockRutile", Fluids.getFluidStack("rutile", MetalRates.BLOCK), 800);
        PluginTConstruct.addMelting(Core.metals, 2, "nuggetRutile", Fluids.getFluidStack("rutile", MetalRates.NUGGET), 800);
        PluginTConstruct.addMelting(Core.metals, 4, "dustTitanium", Fluids.getFluidStack("titanium", MetalRates.INGOT), 800);
        PluginTConstruct.addMelting(Core.metals, 4, "ingotTitanium", Fluids.getFluidStack("titanium", MetalRates.INGOT), 800);
        PluginTConstruct.addMelting(Core.metals, 4, "blockTitanium", Fluids.getFluidStack("titanium", MetalRates.BLOCK), 800);
        PluginTConstruct.addMelting(Core.metals, 4, "nuggetTitanium", Fluids.getFluidStack("titanium", MetalRates.NUGGET), 800);
        PluginTConstruct.addCasting("ingotRutile", Fluids.getFluidStack("rutile", MetalRates.INGOT), 100);
        PluginTConstruct.addCasting("ingotTitanium", Fluids.getFluidStack("titanium", MetalRates.INGOT), 100);
        PluginTConstruct.addBlockCasting("blockTitanium", Fluids.getFluidStack("titanium", MetalRates.BLOCK), 100);
        PluginTConstruct.addMelting(Core.rocks, 2, "oreMagnesium", Fluids.getFluidStack("magnesium", MetalRates.ORE), 300);
        PluginTConstruct.addMelting(Core.metals, 3, "dustMagnesium", Fluids.getFluidStack("magnesium", MetalRates.INGOT), 300);
        PluginTConstruct.addMelting(Core.metals, 3, "ingotMagnesium", Fluids.getFluidStack("magnesium", MetalRates.INGOT), 300);
        PluginTConstruct.addMelting(Core.metals, 3, "blockMagnesium", Fluids.getFluidStack("magnesium", MetalRates.BLOCK), 300);
        PluginTConstruct.addMelting(Core.metals, 3, "nuggetMagnesium", Fluids.getFluidStack("magnesium", MetalRates.NUGGET), 300);
        PluginTConstruct.addCasting("ingotMagnesium", Fluids.getFluidStack("magnesium", MetalRates.INGOT), 100);
        PluginTConstruct.addBlockCasting("blockMagnesium", Fluids.getFluidStack("magnesium", MetalRates.BLOCK), 100);
        if (FluidRegistry.getFluid((String)"xpjuice") != null) {
            ItemStack xpberry = TConstructRegistry.getItemStack((String)"oreberryEssence");
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            ArrayList<Integer> chances = new ArrayList<Integer>();
            int j = 3;
            for (int i = 80; i <= 120; i += 10) {
                chances.add(j);
                fluids.add(FluidRegistry.getFluidStack((String)"xpjuice", (int)i));
                ++j;
            }
            MaricultureHandlers.crucible.addRecipe(new RecipeSmelter(xpberry, 1000, fluids.toArray(new FluidStack[fluids.size()]), chances.toArray(new Integer[chances.size()]), null, 0));
        }
    }

    private static void addAlloy() {
        FluidStack titanium = Fluids.getFluidStack("titanium", 8);
        FluidStack rutile = Fluids.getFluidStack("rutile", 8);
        FluidStack magnesium = Fluids.getFluidStack("magnesium", 8);
        Smeltery.addAlloyMixing((FluidStack)titanium, (FluidStack[])new FluidStack[]{rutile, magnesium});
    }

    private static void addModifiers() {
        ToolBuilder tb = ToolBuilder.instance;
        ItemStack pearl = new ItemStack(Core.pearls, 1, Short.MAX_VALUE);
        ItemStack pearlBlock = new ItemStack(Core.pearlBlock, 1, Short.MAX_VALUE);
        ModifyBuilder.registerModifier((ItemModifier)new ModPearl(new ItemStack[]{pearl}, 200, 1));
        ModifyBuilder.registerModifier((ItemModifier)new ModPearl(new ItemStack[]{pearl, pearl}, 200, 2));
        ModifyBuilder.registerModifier((ItemModifier)new ModPearl(new ItemStack[]{pearlBlock}, 200, 4));
        ModifyBuilder.registerModifier((ItemModifier)new ModPearl(new ItemStack[]{pearl, pearlBlock}, 200, 5));
        ModifyBuilder.registerModifier((ItemModifier)new ModPearl(new ItemStack[]{pearlBlock, pearlBlock}, 200, 8));
        for (ToolCore tool : TConstructRegistry.getToolMapping()) {
            if (!(tool instanceof HarvestTool)) continue;
            TConstructClientRegistry.addEffectRenderMapping((ToolCore)tool, (int)200, (String)"mariculture", (String)"pearl", (boolean)true);
        }
    }

    public static void addMelting(Block block, int meta, String dic, FluidStack fluid, int temp) {
        if (fluid == null) {
            return;
        }
        if (OreDictionary.getOres((String)dic).size() > 0) {
            for (ItemStack ore : OreDictionary.getOres((String)dic)) {
                if (block == null) continue;
                Smeltery.addMelting((ItemStack)ore, (Block)block, (int)meta, (int)temp, (FluidStack)fluid);
            }
        }
    }

    public static void addCasting(String dic, FluidStack fluid, int delay) {
        if (OreDictionary.getOres((String)dic).size() > 0) {
            TConstructRegistry.getTableCasting().addCastingRecipe((ItemStack)OreDictionary.getOres((String)dic).get(0), fluid, TConstructRegistry.getItemStack((String)"ingotCast"), delay);
        }
    }

    public static void addBlockCasting(String dic, FluidStack fluid, int delay) {
        if (OreDictionary.getOres((String)dic).size() > 0) {
            TConstructRegistry.getBasinCasting().addCastingRecipe((ItemStack)OreDictionary.getOres((String)dic).get(0), fluid, delay);
        }
    }

    public static void addPartCasting(ItemStack output, ItemStack cast, FluidStack fluid, int hardeningDelay) {
        TConstructRegistry.getTableCasting().addCastingRecipe(output, fluid, cast, hardeningDelay);
    }
}

