/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.ArrayList;
import mariculture.core.gui.feature.Feature;
import mariculture.core.gui.feature.FeatureTank;
import mariculture.plugins.nei.NEIConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class NEIBase
extends TemplateRecipeHandler {
    protected void drawFluidRect(int j, int k, FluidStack fluid, FeatureTank.TankSize size) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        int scale = fluid.amount * 58 / 5000;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (size.equals((Object)FeatureTank.TankSize.VAT)) {
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k, fluid.getFluid().getIcon(), 16, 16);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 16, k, fluid.getFluid().getIcon(), 7, 16);
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k - 16, fluid.getFluid().getIcon(), 16, 16);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 16, k - 16, fluid.getFluid().getIcon(), 7, 16);
        }
        if (size.equals((Object)FeatureTank.TankSize.CASTER)) {
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k, fluid.getFluid().getIcon(), 16, 16);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 21, k, fluid.getFluid().getIcon(), 16, 16);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 21, k + 21, fluid.getFluid().getIcon(), 16, 16);
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k + 21, fluid.getFluid().getIcon(), 16, 16);
        }
        if (size.equals((Object)FeatureTank.TankSize.BLOCK_CASTER)) {
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k, fluid.getFluid().getIcon(), 12, 12);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 12, k, fluid.getFluid().getIcon(), 13, 12);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 25, k, fluid.getFluid().getIcon(), 12, 12);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 25, k + 12, fluid.getFluid().getIcon(), 12, 13);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 12, k + 12, fluid.getFluid().getIcon(), 13, 13);
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k + 12, fluid.getFluid().getIcon(), 12, 13);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 25, k + 25, fluid.getFluid().getIcon(), 12, 12);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 12, k + 25, fluid.getFluid().getIcon(), 13, 12);
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k + 25, fluid.getFluid().getIcon(), 12, 12);
        }
        if (size.equals((Object)FeatureTank.TankSize.NUGGET_CASTER)) {
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k + 10, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k + 21, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k + 31, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 10, k, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 10, k + 10, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 10, k + 21, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 10, k + 31, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 21, k, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 21, k + 10, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 21, k + 21, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 21, k + 31, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 31, k, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 31, k + 10, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 31, k + 21, fluid.getFluid().getIcon(), 6, 6);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 31, k + 31, fluid.getFluid().getIcon(), 6, 6);
        }
        if (size.equals((Object)FeatureTank.TankSize.DOUBLE)) {
            NEIBase.drawScaledTexturedModelRectFromIcon(j, k, fluid.getFluid().getIcon(), 16, 16);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 16, k, fluid.getFluid().getIcon(), 16, 16);
            NEIBase.drawScaledTexturedModelRectFromIcon(j + 32, k, fluid.getFluid().getIcon(), 2, 16);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Feature.texture);
            GuiDraw.drawTexturedModalRect((int)j, (int)(k - 42), (int)16, (int)0, (int)34, (int)60);
        }
        GuiDraw.changeTexture((String)this.getGuiTexture());
    }

    public int getGuiWidth(GuiRecipe gui) {
        try {
            Field f = gui.getClass().getField("width");
            return (Integer)f.get(gui);
        }
        catch (NoSuchFieldException e) {
            try {
                Field f = gui.getClass().getField("field_146294_l");
                return (Integer)f.get(gui);
            }
            catch (Exception e2) {
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getGuiHeight(GuiRecipe gui) {
        try {
            Field f = gui.getClass().getField("height");
            return (Integer)f.get(gui);
        }
        catch (NoSuchFieldException e) {
            try {
                Field f = gui.getClass().getField("field_146295_m");
                return (Integer)f.get(gui);
            }
            catch (Exception e2) {
                return 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void drawScaledTexturedModelRectFromIcon(int i, int j, IIcon icon, int x, int y) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(i + 0), (double)(j + y), (double)GuiDraw.gui.getZLevel(), minU, minV + (maxV - minV) * (double)y / 16.0);
        tessellator.func_78374_a((double)(i + x), (double)(j + y), (double)GuiDraw.gui.getZLevel(), minU + (maxU - minU) * (double)x / 16.0, minV + (maxV - minV) * (double)y / 16.0);
        tessellator.func_78374_a((double)(i + x), (double)(j + 0), (double)GuiDraw.gui.getZLevel(), minU + (maxU - minU) * (double)x / 16.0, minV);
        tessellator.func_78374_a((double)(i + 0), (double)(j + 0), (double)GuiDraw.gui.getZLevel(), minU, minV);
        tessellator.func_78381_a();
    }

    public boolean isSecondSearch(String outputId, Object ... results) {
        return outputId.equals("fluid") && results.length == 2 && results[0] instanceof String && results[0].equals("fluid");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fluid") && results.length == 1 && results[0] instanceof FluidStack) {
            FluidStack fluidStack = (FluidStack)results[0];
            if (fluidStack == null || fluidStack.getFluid() == null) {
                return;
            }
            String fluid = ((FluidStack)results[0]).getFluid().getName();
            ArrayList<ItemStack> stacks = NEIConfig.containers.get(fluid);
            if (stacks != null) {
                for (ItemStack stack : stacks) {
                    GuiCraftingRecipe.openRecipeGui((String)"item", (Object[])new Object[]{stack});
                }
            }
            GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{"fluid", fluid});
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fluid") && ingredients.length == 1) {
            Fluid fluidz = ((FluidStack)ingredients[0]).getFluid();
            if (fluidz == null) {
                return;
            }
            String fluid = fluidz.getName();
            ArrayList<ItemStack> stacks = NEIConfig.containers.get(fluid);
            if (stacks != null) {
                for (ItemStack stack : stacks) {
                    GuiUsageRecipe.openRecipeGui((String)"item", (Object[])new Object[]{stack});
                }
            }
            GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{"fluid", fluid});
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public Point getMouse(int width, int height) {
        Point mousepos = GuiDraw.getMousePosition();
        int guiLeft = (width - 176) / 2;
        int guiTop = (height - 166) / 2;
        Point relMouse = new Point(mousepos.x - guiLeft, mousepos.y - guiTop);
        return relMouse;
    }

    public void loadFluidsButton(int button, FluidStack fluid) {
        if (button == 0) {
            this.loadFluidRecipes(fluid);
        } else if (button == 1) {
            this.loadFluidUsages(fluid);
        }
    }

    public void loadFluidsKey(int key, FluidStack fluid) {
        if (key == NEIClientConfig.getKeyBinding((String)"gui.recipe")) {
            this.loadFluidRecipes(fluid);
        } else if (key == NEIClientConfig.getKeyBinding((String)"gui.usage")) {
            this.loadFluidUsages(fluid);
        }
    }

    public void loadFluidRecipes(FluidStack fluid) {
        GuiCraftingRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{fluid});
    }

    public void loadFluidUsages(FluidStack fluid) {
        GuiUsageRecipe.openRecipeGui((String)"fluid", (Object[])new Object[]{fluid});
    }

    public abstract boolean isOverItem(GuiRecipe var1, int var2);
}

