/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishProduct;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.api.util.Text;
import mariculture.fishery.items.ItemFishy;
import mariculture.plugins.nei.NEIBase;
import mariculture.plugins.nei.NEIFishBreedingMutationHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class NEIFishProductHandler
extends NEIBase {
    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fishproducts") && ((Object)((Object)this)).getClass() == NEIFishProductHandler.class) {
            for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
                Integer fishID = species.getKey();
                FishSpecies fish = species.getValue();
                if (fish.getProductList() == null) continue;
                this.arecipes.add(new CachedProductRecipe(Fishing.fishHelper.makePureFish(fish), fish.getProductList()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
            FishSpecies fish = species.getValue();
            if (fish.getProductList() == null) continue;
            for (FishProduct product : fish.getProductList()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)product.product, (ItemStack)result)) continue;
                this.arecipes.add(new CachedProductRecipe(Fishing.fishHelper.makePureFish(fish), fish.getProductList()));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!(ingredient.func_77973_b() instanceof ItemFishy)) {
            return;
        }
        for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
            FishSpecies fish = species.getValue();
            if (!NEIFishBreedingMutationHandler.isSpecies(ingredient, fish, false) || fish.getProductList() == null) continue;
            this.arecipes.add(new CachedProductRecipe(Fishing.fishHelper.makePureFish(fish), fish.getProductList()));
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int id) {
        CachedProductRecipe cache;
        if (stack != null && (cache = (CachedProductRecipe)((Object)this.arecipes.get(id))) != null) {
            for (ProductResult r : cache.outputs) {
                if (!gui.isMouseOver(r.stack, id)) continue;
                currenttip.add("\u00a76" + r.chance + "% " + Text.translate("chance"));
            }
        }
        return currenttip;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(41, 19, 22, 16), "fishproducts", new Object[0]));
    }

    public String getRecipeName() {
        return "Fish Products";
    }

    @Override
    public boolean isOverItem(GuiRecipe gui, int id) {
        return false;
    }

    public String getGuiTexture() {
        return new ResourceLocation("mariculture", "textures/gui/nei/fishproducts.png").toString();
    }

    public String getOverlayIdentifier() {
        return "fishproducts";
    }

    public class CachedProductRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        List<ProductResult> outputs;

        public CachedProductRecipe(ItemStack input, ArrayList<FishProduct> outputs) {
            super((TemplateRecipeHandler)NEIFishProductHandler.this);
            this.outputs = new ArrayList<ProductResult>();
            this.input = new PositionedStack((Object)input, 11, 21);
            int x = 0;
            int y = 0;
            for (FishProduct fish : outputs) {
                this.outputs.add(new ProductResult(fish.product.func_77946_l(), x, y, fish.chance));
                if (x == 4) {
                    x = 0;
                    ++y;
                    continue;
                }
                ++x;
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            for (ProductResult result : this.outputs) {
                stacks.add(result.stack);
            }
            return stacks;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }
    }

    public class ProductResult {
        public int x;
        public int y;
        public int bump;
        public int bump2;
        double chance;
        public PositionedStack stack;

        public ProductResult(ItemStack stack, int x, int y, double chance) {
            this.bump = x;
            this.bump2 = y;
            this.chance = chance;
            this.x = 72 + x * 18;
            this.y = 2 + y * 18;
            this.stack = new PositionedStack((Object)stack, this.x, this.y);
        }
    }
}

