/*
 * Decompiled with CFR 0.152.
 */
package mariculture.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mariculture.api.util.Text;
import mariculture.core.blocks.base.ItemBlockMariculture;
import mariculture.world.BlockCoral;
import mariculture.world.WorldPlus;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockCoralItem
extends ItemBlockMariculture {
    private IIcon[] icons;
    private Block spawnBlock;

    public BlockCoralItem(Block block) {
        super(block);
        this.spawnBlock = block;
    }

    public String func_77653_i(ItemStack stack) {
        if (this.spawnBlock == WorldPlus.plantGrowable) {
            return super.func_77653_i(stack);
        }
        return Text.localize("mariculture.string.dried") + " " + super.func_77653_i(stack);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return "item.coral." + this.getName(stack);
    }

    @Override
    public String getName(ItemStack stack) {
        String name = "";
        switch (stack.func_77960_j()) {
            case 1: {
                return "kelp";
            }
            case 0: {
                return "kelp_middle";
            }
            case 4: {
                return "blue";
            }
            case 7: {
                return "yellow";
            }
            case 5: {
                return "magenta";
            }
            case 6: {
                return "brown";
            }
            case 8: {
                return "orange";
            }
            case 2: {
                return "pink";
            }
            case 9: {
                return "purple";
            }
            case 3: {
                return "red";
            }
            case 10: {
                return "grey";
            }
            case 11: {
                return "lightgrey";
            }
            case 12: {
                return "white";
            }
        }
        return "coral";
    }

    public IIcon func_77617_a(int dmg) {
        if (dmg < this.getMetaCount()) {
            return this.icons[dmg];
        }
        return this.icons[0];
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        int j1;
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150433_aE && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        } else if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (this.canPlaceBlockOnSide(world, x, y, z, side, stack) && world.func_147465_d(x, y, z, this.spawnBlock, j1 = stack.func_77960_j(), 2)) {
            if (world.func_147439_a(x, y, z) == this.spawnBlock) {
                this.spawnBlock.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
                this.spawnBlock.func_149714_e(world, x, y, z, j1);
            }
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    private boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side, ItemStack stack) {
        if (side != 1) {
            return false;
        }
        if (world.func_147439_a(x, y + 1, z).func_149688_o() != Material.field_151586_h) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        int meta = world.func_72805_g(x, y - 1, z);
        if (stack.func_77960_j() == 1) {
            return BlockCoral.canSustainKelp(block, meta);
        }
        if (stack.func_77960_j() > 0) {
            return BlockCoral.canSustainCoral(block, meta);
        }
        return false;
    }

    @Override
    public int getMetaCount() {
        return 13;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("mariculture:coral_" + this.getName(new ItemStack((Item)this, 1, i)));
        }
    }
}

