/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PlayerSensor
extends Block {
    public PlayerSensor(int id) {
        super(id, Material.field_76265_p);
        this.func_71849_a(CreativeTabs.field_78028_d);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.field_94336_cN = iconRegister.func_94245_a("malisisdoors:" + this.func_71917_a().substring(5));
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_71850_a_(World world, int x, int y, int z, int d) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)d);
        return dir == ForgeDirection.NORTH && world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST) || dir == ForgeDirection.EAST && world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST);
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST) || world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST) || world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH) || world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH);
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        metadata = world.func_72805_g(x, y, z);
        int k1 = metadata & 8;
        metadata &= 7;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        metadata = dir == ForgeDirection.NORTH && world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH) ? 4 : (dir == ForgeDirection.SOUTH && world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH) ? 3 : (dir == ForgeDirection.WEST && world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST) ? 2 : (dir == ForgeDirection.EAST && world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST) ? 1 : this.getOrientation(world, x, y, z))));
        return metadata + k1;
    }

    private int getOrientation(World world, int x, int y, int z) {
        if (world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST)) {
            return 1;
        }
        if (world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST)) {
            return 2;
        }
        if (world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH)) {
            return 3;
        }
        if (world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH)) {
            return 4;
        }
        return 1;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        float f = 0.125f;
        int dir = metadata & 7;
        if (dir == 1) {
            this.func_71905_a(0.0f, f, f, f, 2.0f * f, 1.0f - f);
        } else if (dir == 2) {
            this.func_71905_a(1.0f - f, f, f, 1.0f, 2.0f * f, 1.0f - f);
        } else if (dir == 3) {
            this.func_71905_a(f, f, 0.0f, 1.0f - f, 2.0f * f, f);
        } else if (dir == 4) {
            this.func_71905_a(f, f, 1.0f - f, 1.0f - f, 2.0f * f, 1.0f);
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int metadata) {
        if (this.redundantCanPlaceBlockAt(world, x, y, z)) {
            int dir = world.func_72805_g(x, y, z) & 7;
            boolean drop = false;
            if (!world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST) && dir == 1) {
                drop = true;
            }
            if (!world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST) && dir == 2) {
                drop = true;
            }
            if (!world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH) && dir == 3) {
                drop = true;
            }
            if (!world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH) && dir == 4) {
                drop = true;
            }
            if (drop) {
                this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_94571_i(x, y, z);
            }
        }
    }

    private boolean redundantCanPlaceBlockAt(World world, int x, int y, int z) {
        if (!this.func_71930_b(world, x, y, z)) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_94571_i(x, y, z);
            return false;
        }
        return true;
    }

    public void func_71852_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        if ((par6 & 8) > 0) {
            int j1 = par6 & 7;
            this.notifyPower(par1World, par2, par3, par4, j1);
        }
        super.func_71852_a(par1World, par2, par3, par4, par5, par6);
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        return (world.func_72805_g(x, y, z) & 8) != 0 ? 15 : 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if ((metadata & 8) == 0) {
            return 0;
        }
        int dir = metadata & 7;
        return dir == 5 && side == 1 ? 15 : (dir == 4 && side == 2 ? 15 : (dir == 3 && side == 3 ? 15 : (dir == 2 && side == 4 ? 15 : (dir == 1 && side == 5 ? 15 : 0))));
    }

    public boolean func_71853_i() {
        return true;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.func_71859_p_(world));
    }

    private AxisAlignedBB getDetectionBox(World world, int x, int y, int z) {
        int dir = world.func_72805_g(x, y, z) & 7;
        double x1 = x;
        double x2 = x;
        double z1 = z;
        double z2 = z;
        int yOffset = 1;
        boolean isAir = world.func_72799_c(x, y - 1, z);
        if (dir == 1) {
            x1 -= 1.0;
            x2 += 2.0;
            z2 += 1.0;
        } else if (dir == 2) {
            x1 -= 1.0;
            x2 += 2.0;
            z2 += 1.0;
        } else if (dir == 3) {
            x2 += 1.0;
            z1 -= 1.0;
            z2 += 2.0;
        } else if (dir == 4) {
            x2 += 1.0;
            z1 -= 1.0;
            z2 += 2.0;
        }
        while (isAir && yOffset < 6) {
            isAir = world.func_72799_c(x, y - yOffset++, z);
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)x1, (double)((double)y - (double)yOffset), (double)z1, (double)x2, (double)y, (double)z2);
        return aabb;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            world.func_72836_a(x, y, z, this.field_71990_ca, this.func_71859_p_(world));
            List list = world.func_72872_a(EntityPlayer.class, this.getDetectionBox(world, x, y, z));
            int metadata = world.func_72805_g(x, y, z);
            if (list != null && !list.isEmpty()) {
                if ((metadata & 8) != 0) {
                    return;
                }
                world.func_72921_c(x, y, z, metadata |= 8, 3);
                this.notifyPower(world, x, y, z, metadata);
            } else if ((metadata & 8) != 0) {
                world.func_72921_c(x, y, z, metadata &= 0xFFFFFFF7, 3);
                this.notifyPower(world, x, y, z, metadata);
            }
        }
    }

    public void func_71919_f() {
        float f = 0.125f;
        this.func_71905_a(f, 0.5f - f, 0.5f - f, 1.0f - f, 0.5f + f, 0.5f + f);
    }

    protected void func_82535_o(World par1World, int par2, int par3, int par4) {
        boolean flag1;
        int l = par1World.func_72805_g(par2, par3, par4);
        int i1 = l & 7;
        boolean flag = (l & 8) != 0;
        List list = par1World.func_72872_a(EntityArrow.class, AxisAlignedBB.func_72332_a().func_72299_a((double)par2 + this.field_72026_ch, (double)par3 + this.field_72023_ci, (double)par4 + this.field_72024_cj, (double)par2 + this.field_72021_ck, (double)par3 + this.field_72022_cl, (double)par4 + this.field_72019_cm));
        boolean bl = flag1 = !list.isEmpty();
        if (flag1 && !flag) {
            par1World.func_72921_c(par2, par3, par4, i1 | 8, 3);
            this.notifyPower(par1World, par2, par3, par4, i1);
            par1World.func_72909_d(par2, par3, par4, par2, par3, par4);
            par1World.func_72908_a((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!flag1 && flag) {
            par1World.func_72921_c(par2, par3, par4, i1, 3);
            this.notifyPower(par1World, par2, par3, par4, i1);
            par1World.func_72909_d(par2, par3, par4, par2, par3, par4);
            par1World.func_72908_a((double)par2 + 0.5, (double)par3 + 0.5, (double)par4 + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (flag1) {
            par1World.func_72836_a(par2, par3, par4, this.field_71990_ca, this.func_71859_p_(par1World));
        }
    }

    private void notifyPower(World world, int x, int y, int z, int dir) {
        world.func_72898_h(x, y, z, this.field_71990_ca);
        if (dir == 1) {
            world.func_72898_h(x - 1, y, z, this.field_71990_ca);
        } else if (dir == 2) {
            world.func_72898_h(x + 1, y, z, this.field_71990_ca);
        } else if (dir == 3) {
            world.func_72898_h(x, y, z - 1, this.field_71990_ca);
        } else if (dir == 4) {
            world.func_72898_h(x, y, z + 1, this.field_71990_ca);
        } else {
            world.func_72898_h(x, y - 1, z, this.field_71990_ca);
        }
    }

    public int func_71859_p_(World par1World) {
        return 5;
    }
}

