/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.malisis.doors.entity.VanishingTileEntity;
import net.malisis.doors.renderer.DefaultBlockRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class VanishingBlock
extends BlockContainer {
    public static final int typeWoodFrame = 0;
    public static final int typeIronFrame = 1;
    public static final int typeGoldFrame = 2;
    public static final int flagPowered = 4;
    public static final int flagInTransition = 8;
    private Icon[] icons = new Icon[3];

    public VanishingBlock(int par1) {
        super(par1, Material.field_76245_d);
        this.func_71849_a(CreativeTabs.field_78028_d);
        this.func_71848_c(0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons[0] = iconRegister.func_94245_a("malisisdoors:vanishingBlockWood");
        this.icons[1] = iconRegister.func_94245_a("malisisdoors:vanishingBlockIron");
        this.icons[2] = iconRegister.func_94245_a("malisisdoors:vanishingBlockGold");
    }

    public Icon func_71858_a(int side, int frameType) {
        if ((frameType &= 3) == 1) {
            return this.icons[1];
        }
        if (frameType == 2) {
            return this.icons[2];
        }
        return this.icons[0];
    }

    public boolean isPowered(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == this.field_71990_ca && (world.func_72805_g(x, y, z) & 4) != 0;
    }

    public void setPowerState(World world, int x, int y, int z, boolean powered) {
        if (world.func_72798_a(x, y, z) != this.field_71990_ca) {
            return;
        }
        if (this.isPowered(world, x, y, z) == powered) {
            return;
        }
        VanishingTileEntity te = (VanishingTileEntity)world.func_72796_p(x, y, z);
        te.setPowerState(powered);
        if (powered) {
            world.func_72921_c(x, y, z, te.field_70325_p | 4, 2);
        } else {
            world.func_72921_c(x, y, z, te.field_70325_p & 0xFFFFFFFB, 2);
        }
        world.func_72836_a(x, y, z, this.field_71990_ca, 1);
    }

    public boolean shouldPropagate(World world, int x, int y, int z, VanishingTileEntity source) {
        if (world.func_72798_a(x, y, z) != this.field_71990_ca) {
            return false;
        }
        if ((source.func_70322_n() & 3) == 0) {
            return true;
        }
        VanishingTileEntity dest = (VanishingTileEntity)world.func_72796_p(x, y, z);
        if (source.copiedBlock == null || dest.copiedBlock == null) {
            return true;
        }
        if ((source.func_70322_n() & 3) == 1 && source.copiedBlockID == dest.copiedBlockID) {
            return true;
        }
        return (source.func_70322_n() & 3) == 2 && source.copiedBlockID == dest.copiedBlockID && source.copiedMetadata == dest.copiedMetadata;
    }

    public void propagateState(World world, int x, int y, int z) {
        VanishingTileEntity te = (VanishingTileEntity)world.func_72796_p(x, y, z);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.shouldPropagate(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, te)) continue;
            this.setPowerState(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, te.powered);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer p, int par6, float par7, float par8, float par9) {
        ItemStack is = p.func_70694_bm();
        if (is == null) {
            return false;
        }
        if (!Block.func_71932_i((int)is.field_77993_c) || is.field_77993_c == this.field_71990_ca) {
            return false;
        }
        VanishingTileEntity te = (VanishingTileEntity)world.func_72796_p(x, y, z);
        if (te.copiedBlock != null) {
            return false;
        }
        te.setBlock(is.field_77993_c, is.func_77960_j());
        this.field_71989_cb = te.copiedBlock.field_71989_cb;
        this.field_72016_cq = te.copiedBlock.field_72016_cq;
        this.field_72020_cn = te.copiedBlock.field_72020_cn;
        if (!p.field_71075_bZ.field_75098_d) {
            --is.field_77994_a;
        }
        world.func_72845_h(x, y, z);
        return true;
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        if (world.field_72995_K) {
            return;
        }
        boolean powered = world.func_72864_z(x, y, z);
        if (powered || blockID > 0 && Block.field_71973_m[blockID].func_71853_i() && blockID != this.field_71990_ca) {
            if (this.isPowered(world, x, y, z) != powered) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "malisisdoors:portal", 0.3f, 0.5f);
            }
            this.setPowerState(world, x, y, z, powered);
        }
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        this.propagateState(world, x, y, z);
    }

    public void func_71852_a(World world, int x, int y, int z, int i, int j) {
        VanishingTileEntity te = (VanishingTileEntity)world.func_72796_p(x, y, z);
        if (te.copiedBlock != null) {
            te.copiedBlock.func_71897_c(world, x, y, z, te.copiedMetadata, 0);
        }
        world.func_72932_q(x, y, z);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        if ((world.func_72805_g(x, y, z) & 0xC) != 0) {
            return null;
        }
        return super.func_71872_e(world, x, y, z);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        if ((world.func_72805_g(x, y, z) & 0xC) != 0) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        list.add(new ItemStack(id, 1, 0));
        list.add(new ItemStack(id, 1, 1));
        list.add(new ItemStack(id, 1, 2));
    }

    public int func_71899_b(int metadata) {
        return metadata;
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public float func_71888_h(IBlockAccess world, int x, int y, int z) {
        return (world.func_72805_g(x, y, z) & 0xC) == 0 ? 0.2f : 1.0f;
    }

    public int func_71857_b() {
        return DefaultBlockRenderer.vanishingBlockRenderId;
    }

    public boolean func_71926_d() {
        return false;
    }

    public TileEntity func_72274_a(World world) {
        return new VanishingTileEntity();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new VanishingTileEntity(metadata);
    }
}

