/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.entity;

import net.malisis.doors.block.Door;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class DoorTileEntity
extends TileEntity {
    public Door field_70324_q;
    public boolean moving = false;
    public int state = 0;
    public float hingeOffsetX;
    public float hingeOffsetZ;
    public float angle;
    public int timer = 0;

    public void startAnimation(int state) {
        if (this.moving && state == this.state) {
            return;
        }
        this.getBlockType();
        this.func_70322_n();
        if (!this.moving) {
            this.timer = state == 3 ? 0 : 4;
        }
        this.moving = true;
        this.state = state;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 2), (double)(this.field_70327_n + 1));
    }

    public void setSlidingDoorPosition(float partialTick) {
        float s;
        boolean reversed;
        int dir = this.func_70322_n() & 3;
        boolean bl = reversed = (this.func_70322_n() & 0x10) != 0;
        if (this.state == 1) {
            partialTick = -partialTick;
        }
        if ((s = ((float)this.timer + partialTick) / 4.0f) > 1.0f) {
            s = 1.0f;
        }
        if (s < 0.0f) {
            s = 0.0f;
        }
        this.hingeOffsetX = 0.0f;
        this.hingeOffsetZ = 0.0f;
        if (dir == 1 && reversed || dir == 3 && !reversed) {
            this.hingeOffsetX = -s;
        }
        if (dir == 1 && !reversed || dir == 3 && reversed) {
            this.hingeOffsetX = s;
        }
        if (dir == 0 && !reversed || dir == 2 && reversed) {
            this.hingeOffsetZ = -s;
        }
        if (dir == 0 && reversed || dir == 2 && !reversed) {
            this.hingeOffsetZ = s;
        }
        this.hingeOffsetX *= 0.8125f;
        this.hingeOffsetZ *= 0.8125f;
    }

    public void setRegularDoorPosition(float partialTick) {
        this.setDoorAngle(partialTick);
        this.setHingeOffset(partialTick);
    }

    private void setDoorAngle(float partialTick) {
        float a;
        if (this.state == 1) {
            partialTick = -partialTick;
        }
        if ((a = ((float)this.timer + partialTick) / 4.0f) > 1.0f) {
            a = 1.0f;
        }
        if (a < 0.0f) {
            a = 0.0f;
        }
        if ((this.field_70325_p & 0x10) != 0) {
            a *= -1.0f;
        }
        this.angle = 90.0f * a;
    }

    public void setHingeOffset(float partialTick) {
        int dir = this.func_70322_n() & 3;
        boolean reversed = (this.func_70322_n() & 0x10) != 0;
        float f = 0.90625f;
        this.hingeOffsetX = 0.09375f;
        this.hingeOffsetZ = 0.09375f;
        if (dir == 3) {
            this.hingeOffsetZ = f;
            if (reversed) {
                this.hingeOffsetX = f;
            }
        }
        if (dir == 1 && !reversed) {
            this.hingeOffsetX = f;
        }
        if (dir == 0 && reversed) {
            this.hingeOffsetZ = f;
        }
        if (dir == 2) {
            this.hingeOffsetX = f;
            if (!reversed) {
                this.hingeOffsetZ = f;
            }
        }
    }

    public float brightnessFactor() {
        int dir = this.func_70322_n() & 3;
        float f = 0.2f * ((float)this.timer / 4.0f);
        f = dir == 3 || dir == 1 ? 0.8f - f : 0.6f + f;
        return f;
    }

    public void func_70316_g() {
        if (!this.moving) {
            return;
        }
        this.timer = this.state == 3 ? ++this.timer : --this.timer;
        if (this.timer > 4 || this.timer < 0) {
            this.moving = false;
            if (this.getBlockType() != null && !this.field_70331_k.field_72995_K) {
                this.field_70324_q.setDoorState(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.state == 1 ? 0 : 2);
            }
        }
    }

    public Door getBlockType() {
        if (this.field_70324_q == null) {
            this.field_70324_q = (Door)Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)];
        }
        return this.field_70324_q;
    }

    public int func_70322_n() {
        return this.getBlockMetadata(false);
    }

    public int getBlockMetadata(boolean top) {
        if (this.getBlockType() != null && this.field_70325_p == -1) {
            this.field_70325_p = this.field_70324_q.func_72234_b_((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n) & 0xFFFFFFFB;
        }
        if (top) {
            this.field_70325_p |= 8;
        }
        return this.field_70325_p & 0xFFFFFFFB;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.timer = nbt.func_74762_e("timer");
        this.moving = nbt.func_74767_n("moving");
        this.state = nbt.func_74762_e("state");
        if (this.field_70331_k != null) {
            this.field_70324_q = (Door)Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n)];
            this.field_70325_p = this.field_70324_q.func_72234_b_((IBlockAccess)this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("timer", this.timer);
        nbt.func_74757_a("moving", this.moving);
        nbt.func_74768_a("state", this.state);
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, nbt);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

