/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import java.util.Random;
import net.malisis.core.renderer.BaseRenderer;
import net.malisis.core.renderer.element.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.doors.block.SlidingDoor;
import net.malisis.doors.entity.DoorTileEntity;
import net.malisis.doors.entity.VanishingTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class TileEntityRenderer
extends TileEntitySpecialRenderer {
    private Tessellator t = null;
    private Random rand = new Random();

    private void init(double x, double y, double z) {
        RenderHelper.func_74518_a();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)2903);
        GL11.glShadeModel((int)7425);
        this.func_110628_a(TextureMap.field_110575_b);
        this.t = Tessellator.field_78398_a;
        this.t.func_78382_b();
    }

    private void next() {
        this.t.func_78381_a();
        this.t.func_78382_b();
    }

    private void end() {
        this.t.func_78381_a();
        GL11.glPopMatrix();
    }

    public void func_76894_a(TileEntity te, double x, double y, double z, float f) {
        boolean test = false;
        if (test) {
            this.test((VanishingTileEntity)te, x, y, z, f);
            return;
        }
        this.init(x, y, z);
        if (te instanceof VanishingTileEntity) {
            this.renderVanishingTileEntityAt((VanishingTileEntity)te, x, y, z, f);
        } else if (te instanceof DoorTileEntity) {
            this.renderDoorTileEntity((DoorTileEntity)te, x, y, z, f);
        }
        this.end();
    }

    public void renderDoorTileEntity(DoorTileEntity te, double x, double y, double z, float f) {
        if (!te.moving) {
            return;
        }
        if (te.getBlockType() instanceof SlidingDoor) {
            te.setSlidingDoorPosition(f);
            GL11.glTranslatef((float)te.hingeOffsetX, (float)0.0f, (float)te.hingeOffsetZ);
        } else {
            te.setRegularDoorPosition(f);
            GL11.glTranslatef((float)te.hingeOffsetX, (float)0.0f, (float)te.hingeOffsetZ);
            GL11.glRotatef((float)te.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-te.hingeOffsetX), (float)0.0f, (float)(-te.hingeOffsetZ));
        }
        BaseRenderer mrenderer = new BaseRenderer().set((IBlockAccess)te.field_70331_k, (Block)te.getBlockType(), te.field_70329_l, te.field_70330_m, te.field_70327_n, te.func_70322_n());
        RenderParameters rp = new RenderParameters();
        rp.renderAllFaces = true;
        rp.useBlockBounds = false;
        rp.renderBounds = te.field_70324_q.calculateBlockBoundsD(te.func_70322_n(), false);
        rp.useBlockBrightness = false;
        rp.brightness = te.field_70331_k.func_72802_i(te.field_70329_l, te.field_70330_m, te.field_70327_n, 0);
        rp.calculateAOColor = false;
        mrenderer.drawShape(Shape.Cube, rp);
        this.next();
        GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
        mrenderer.set(te.field_70329_l, te.field_70330_m + 1, te.field_70327_n);
        mrenderer.set(te.func_70322_n() | 8);
        mrenderer.drawShape(Shape.Cube, rp);
    }

    public void renderVanishingTileEntityAt(VanishingTileEntity te, double x, double y, double z, float f) {
        if (!te.inTransition && !te.vibrating) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        BaseRenderer mrenderer = new BaseRenderer().set((IBlockAccess)te.field_70331_k, te.field_70324_q, te.field_70329_l, te.field_70330_m, te.field_70327_n, te.field_70325_p);
        RenderParameters params = RenderParameters.Default();
        float fx = 0.0f;
        float fy = 0.0f;
        float fz = 0.0f;
        float scale = (float)(6 - te.transitionTimer) / 6.0f;
        params.useBlockBounds = false;
        if (!te.inTransition && !te.powered) {
            params.alpha = 200;
            fx = this.rand.nextFloat() * 0.05f;
            fy = this.rand.nextFloat() * 0.05f;
            fz = this.rand.nextFloat() * 0.05f;
            if (this.rand.nextBoolean()) {
                GL11.glTranslated((double)fx, (double)fy, (double)fz);
            } else {
                GL11.glRotatef((float)this.rand.nextInt(5), (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else {
            params.alpha = (int)(scale * 255.0f);
            params.scale = Float.valueOf(scale);
        }
        mrenderer.drawShape(Shape.Cube, params);
        if (te.copiedBlock != null) {
            mrenderer.set(te.copiedBlock, te.copiedMetadata);
            mrenderer.drawShape(Shape.Cube, params);
        }
    }

    public void test(VanishingTileEntity te, double x, double y, double z, float f) {
    }
}

