/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.malisis.doors.entity.DoorTileEntity;
import net.malisis.doors.renderer.block.DoorRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.IconFlipped;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class Door
extends BlockDoor
implements ITileEntityProvider {
    protected Icon[] iconTop;
    protected Icon[] iconBottom;
    protected Icon iconSide;
    protected String soundPath;
    public static final int DIR_WEST = 0;
    public static final int DIR_NORTH = 1;
    public static final int DIR_EAST = 2;
    public static final int DIR_SOUTH = 3;
    public static final float DOOR_WIDTH = 0.1875f;
    public static final int flagOpened = 4;
    public static final int flagTopBlock = 8;
    public static final int flagReversed = 16;
    public static final int stateClose = 0;
    public static final int stateClosing = 1;
    public static final int stateOpen = 2;
    public static final int stateOpening = 3;
    public static final int openingTime = 4;

    public Door(int id, Material material) {
        super(id, material);
        float f = 0.5f;
        float f1 = 1.0f;
        this.func_71905_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
        this.func_71896_v();
        this.field_72025_cg = true;
        if (material == Material.field_76245_d) {
            this.func_71848_c(3.0f);
            this.func_71884_a(field_71967_e);
            this.func_71864_b("doorWood");
            this.func_71896_v();
            this.func_111022_d("door_wood");
        } else {
            this.func_71848_c(5.0f);
            this.func_71884_a(field_71977_i);
            this.func_71864_b("doorIron");
            this.func_111022_d("door_iron");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        if (side == 1 || side == 0) {
            return this.iconSide;
        }
        int dir = metadata & 3;
        boolean opened = (metadata & 4) != 0;
        boolean topBlock = (metadata & 8) != 0;
        boolean reversed = false;
        if ((dir == 1 || dir == 3) && !opened || (dir == 0 || dir == 2) && opened ? side == 4 || side == 5 : side == 2 || side == 3) {
            return this.iconSide;
        }
        if (opened) {
            if (dir == 0 && side == 2) {
                reversed = true;
            } else if (dir == 1 && side != 4) {
                reversed = true;
            } else if (dir == 2 && side == 3) {
                reversed = true;
            } else if (dir == 3 && side == 4) {
                reversed = true;
            }
        } else {
            if (dir == 0 && side == 5) {
                reversed = true;
            } else if (dir == 1 && side == 3) {
                reversed = true;
            } else if (dir == 2 && side == 4) {
                reversed = true;
            } else if (dir == 3 && side == 2) {
                reversed = true;
            }
            if ((metadata & 0x10) != 0) {
                boolean bl = reversed = !reversed;
            }
        }
        return topBlock ? this.iconTop[reversed ? 1 : 0] : this.iconBottom[reversed ? 1 : 0];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_71858_a(side, this.func_72234_b_(world, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.iconTop = new Icon[2];
        this.iconBottom = new Icon[2];
        this.iconSide = register.func_94245_a("malisisdoors:" + this.func_111023_E() + "_side");
        this.iconTop[0] = register.func_94245_a(this.func_111023_E() + "_upper");
        this.iconBottom[0] = register.func_94245_a(this.func_111023_E() + "_lower");
        this.iconTop[1] = new IconFlipped(this.iconTop[0], true, false);
        this.iconBottom[1] = new IconFlipped(this.iconBottom[0], true, false);
    }

    public void setDoorState(World world, int x, int y, int z, int state) {
        int metadata;
        y -= ((metadata = this.func_72234_b_((IBlockAccess)world, x, y, z)) & 8) != 0 ? 1 : 0;
        if (state == 3 || state == 1) {
            if (!world.field_72995_K) {
                DoorTileEntity te = (DoorTileEntity)world.func_72796_p(x, y, z);
                if (te != null) {
                    if (!te.moving) {
                        this.playSound(world, x, y, z, state);
                    }
                    te.startAnimation(state);
                }
                world.func_72845_h(x, y, z);
            }
        } else {
            int bottomMetadata = metadata & 7;
            bottomMetadata = state == 2 ? bottomMetadata | 4 : bottomMetadata & 0xFFFFFFFB;
            world.func_72921_c(x, y, z, bottomMetadata, 2);
            world.func_72845_h(x, y, z);
            this.playSound(world, x, y, z, state);
        }
    }

    public void playSound(World world, int x, int y, int z, int state) {
        if (state == 3) {
            world.func_72908_a((double)x, (double)y, (double)z, "random.door_open", 1.0f, 1.0f);
        } else if (state == 0) {
            world.func_72908_a((double)x, (double)y, (double)z, "random.door_close", 1.0f, 1.0f);
        }
    }

    public boolean isDoubleDoor(World world, int x, int y, int z, int metadata) {
        int metadata2 = this.func_72234_b_((IBlockAccess)world, x, y, z);
        if (world.func_72798_a(x, y, z) != this.field_71990_ca) {
            return false;
        }
        if ((metadata & 3) != (metadata2 & 3)) {
            return false;
        }
        if ((metadata & 4) != (metadata2 & 4)) {
            return false;
        }
        return (metadata & 0x10) != (metadata2 & 0x10);
    }

    protected ForgeDirection findDoubleDoor(World world, int x, int y, int z) {
        int metadata = this.func_72234_b_((IBlockAccess)world, x, y, z);
        int dir = metadata & 3;
        if (dir == 1 || dir == 3) {
            if (this.isDoubleDoor(world, x - 1, y, z, metadata)) {
                return ForgeDirection.WEST;
            }
            if (this.isDoubleDoor(world, x + 1, y, z, metadata)) {
                return ForgeDirection.EAST;
            }
        } else if (dir == 2 || dir == 0) {
            if (this.isDoubleDoor(world, x, y, z - 1, metadata)) {
                return ForgeDirection.NORTH;
            }
            if (this.isDoubleDoor(world, x, y, z + 1, metadata)) {
                return ForgeDirection.SOUTH;
            }
        }
        return null;
    }

    protected void openDoubleDoor(World world, int x, int y, int z, int state) {
        ForgeDirection d = this.findDoubleDoor(world, x, y, z);
        if (d != null) {
            this.setDoorState(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, state);
        }
    }

    protected boolean isDoubleDoorPowered(World world, int x, int y, int z) {
        ForgeDirection d = this.findDoubleDoor(world, x, y, z);
        if (d != null) {
            return world.func_72864_z(x + d.offsetX, y + d.offsetY, z + d.offsetZ) || world.func_72864_z(x + d.offsetX, y + d.offsetY + 1, z + d.offsetZ);
        }
        return false;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer p, int par6, float par7, float par8, float par9) {
        if (this.field_72018_cp == Material.field_76243_f) {
            return false;
        }
        boolean opened = (this.func_72234_b_((IBlockAccess)world, x, y, z) & 4) != 0;
        this.setDoorState(world, x, y, z, opened ? 1 : 3);
        this.openDoubleDoor(world, x, y, z, opened ? 1 : 3);
        return true;
    }

    public void func_72231_a(World world, int x, int y, int z, boolean powered) {
        boolean opened = (this.func_72234_b_((IBlockAccess)world, x, y, z) & 4) != 0;
        DoorTileEntity te = (DoorTileEntity)world.func_72796_p(x, y, z);
        if (opened != powered || te != null && te.moving) {
            if (!powered && this.isDoubleDoorPowered(world, x, y, z)) {
                return;
            }
            this.setDoorState(world, x, y, z, powered ? 3 : 1);
            this.openDoubleDoor(world, x, y, z, powered ? 3 : 1);
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int blockID) {
        int metadata = world.func_72805_g(x, y, z);
        if ((metadata & 8) == 0) {
            boolean flag = false;
            if (world.func_72798_a(x, y + 1, z) != this.field_71990_ca) {
                world.func_94571_i(x, y, z);
                flag = true;
            }
            if (!world.func_72797_t(x, y - 1, z)) {
                world.func_94571_i(x, y, z);
                flag = true;
                if (world.func_72798_a(x, y + 1, z) == this.field_71990_ca) {
                    world.func_94571_i(x, y + 1, z);
                }
            }
            if (flag) {
                if (!world.field_72995_K) {
                    this.func_71897_c(world, x, y, z, metadata, 0);
                }
            } else {
                boolean flag1;
                boolean bl = flag1 = world.func_72864_z(x, y, z) || world.func_72864_z(x, y + 1, z);
                if ((flag1 || blockID > 0 && Block.field_71973_m[blockID].func_71853_i()) && blockID != this.field_71990_ca) {
                    this.func_72231_a(world, x, y, z, flag1);
                }
            }
        } else {
            if (world.func_72798_a(x, y - 1, z) != this.field_71990_ca) {
                world.func_94571_i(x, y, z);
            }
            if (blockID > 0 && blockID != this.field_71990_ca) {
                this.func_71863_a(world, x, y - 1, z, blockID);
            }
        }
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState(world, x, y, z, false);
    }

    public boolean setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z, boolean selBox) {
        int metadata = this.func_72234_b_(world, x, y, z);
        boolean topBlock = (metadata & 8) != 0;
        DoorTileEntity te = (DoorTileEntity)world.func_72796_p(x, y - (topBlock ? 1 : 0), z);
        if (te != null && te.moving) {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            return false;
        }
        float[][] bounds = this.calculateBlockBounds(metadata, selBox);
        this.func_71905_a(bounds[0][0], bounds[0][1], bounds[0][2], bounds[1][0], bounds[1][1], bounds[1][2]);
        return true;
    }

    public double[][] calculateBlockBoundsD(int metadata, boolean selBox) {
        float[][] bounds = this.calculateBlockBounds(metadata, selBox);
        return new double[][]{{bounds[0][0], bounds[0][1], bounds[0][2]}, {bounds[1][0], bounds[1][1], bounds[1][2]}};
    }

    public float[][] calculateBlockBounds(int metadata, boolean selBox) {
        float f = 0.1875f;
        int dir = metadata & 3;
        boolean topBlock = (metadata & 8) != 0;
        boolean opened = (metadata & 4) != 0;
        boolean reversed = (metadata & 0x10) != 0;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (selBox) {
            y -= (float)(topBlock ? 1 : 0);
            Y += (float)(!topBlock ? 1 : 0);
        }
        if (dir == 1 && !opened || dir == 0 && opened && !reversed || dir == 2 && opened && reversed) {
            Z = f;
        } else if (dir == 0 && !opened || dir == 3 && opened && !reversed || dir == 1 && opened && reversed) {
            X = f;
        } else if (dir == 2 && !opened || dir == 1 && opened && !reversed || dir == 3 && opened && reversed) {
            x = 1.0f - f;
        } else if (dir == 3 && !opened || dir == 2 && opened && !reversed || dir == 0 && opened && reversed) {
            z = 1.0f - f;
        }
        return new float[][]{{x, y, z}, {X, Y, Z}};
    }

    public int func_72234_b_(IBlockAccess world, int x, int y, int z) {
        int topMetadata;
        int bottomMetadata;
        boolean blockTop;
        int metadata = world.func_72805_g(x, y, z);
        boolean bl = blockTop = (metadata & 8) != 0;
        if (blockTop) {
            bottomMetadata = world.func_72805_g(x, y - 1, z);
            topMetadata = metadata;
        } else {
            bottomMetadata = metadata;
            topMetadata = world.func_72805_g(x, y + 1, z);
        }
        boolean flag1 = (topMetadata & 1) != 0;
        return bottomMetadata & 7 | (blockTop ? 8 : 0) | (flag1 ? 16 : 0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World par1World, int par2, int par3, int par4) {
        return this.field_72018_cp == Material.field_76243_f ? Item.field_77766_aB.field_77779_bT : Item.field_77790_av.field_77779_bT;
    }

    public void func_71846_a(World world, int x, int y, int z, int metadata, EntityPlayer p) {
        if (p.field_71075_bZ.field_75098_d && (metadata & 8) != 0 && world.func_72798_a(x, y - 1, z) == this.field_71990_ca) {
            world.func_94571_i(x, y - 1, z);
        }
    }

    public boolean func_71883_b(World world, int x, int y, int z, int blockID, int eventID) {
        super.func_71883_b(world, x, y, z, blockID, eventID);
        TileEntity tileentity = world.func_72796_p(x, y, z);
        return tileentity != null ? tileentity.func_70315_b(blockID, eventID) : false;
    }

    public int func_71885_a(int metadata, Random par2Random, int par3) {
        return (metadata & 8) != 0 ? 0 : (this.field_72018_cp == Material.field_76243_f ? Item.field_77766_aB.field_77779_bT : Item.field_77790_av.field_77779_bT);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        if (this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z, true)) {
            return this.getAABB(world, x, y, z);
        }
        return null;
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        if (this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z, false)) {
            return this.getAABB(world, x, y, z);
        }
        return null;
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 par5Vec3, Vec3 par6Vec3) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z, false);
        return super.func_71878_a(world, x, y, z, par5Vec3, par6Vec3);
    }

    public AxisAlignedBB getAABB(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl, (double)z + this.field_72019_cm);
    }

    public int func_71915_e() {
        return 1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71918_c(IBlockAccess world, int x, int y, int z) {
        return (this.func_72234_b_(world, x, y, z) & 4) != 0;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return DoorRenderer.renderId;
    }

    public TileEntity func_72274_a(World world) {
        return new DoorTileEntity();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new DoorTileEntity();
    }
}

