/*
 * Decompiled with CFR 0.152.
 */
package minetweaker;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import minetweaker.ClassRegistry;
import minetweaker.IBracketHandler;
import minetweaker.IRecipeRemover;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.annotations.BracketHandler;
import minetweaker.annotations.ModOnly;
import minetweaker.api.client.IClient;
import minetweaker.api.event.IEventManager;
import minetweaker.api.game.IGame;
import minetweaker.api.mods.ILoadedMods;
import minetweaker.api.oredict.IOreDict;
import minetweaker.api.recipes.IFurnaceManager;
import minetweaker.api.recipes.IRecipeManager;
import minetweaker.api.server.IServer;
import minetweaker.runtime.GlobalRegistry;
import minetweaker.runtime.ILogger;
import minetweaker.runtime.ITweaker;
import minetweaker.runtime.MTTweaker;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolJavaStaticField;
import stanhebben.zenscript.symbols.SymbolJavaStaticGetter;
import stanhebben.zenscript.symbols.SymbolJavaStaticMethod;
import stanhebben.zenscript.type.natives.JavaMethod;

public class MineTweakerAPI {
    public static final ITweaker tweaker;
    public static IOreDict oreDict;
    public static IRecipeManager recipes;
    public static IFurnaceManager furnace;
    public static final IEventManager events;
    public static IServer server;
    public static IClient client;
    public static IGame game;
    public static ILoadedMods loadedMods;

    private MineTweakerAPI() {
    }

    public static final ILogger getLogger() {
        return MineTweakerImplementationAPI.logger;
    }

    public static void apply(IUndoableAction action) {
        tweaker.apply(action);
    }

    public static void logCommand(String message) {
        MineTweakerAPI.getLogger().logCommand(message);
    }

    public static void logInfo(String message) {
        MineTweakerAPI.getLogger().logInfo(message);
    }

    public static void logWarning(String message) {
        MineTweakerAPI.getLogger().logWarning(message);
    }

    public static void logError(String message) {
        MineTweakerAPI.getLogger().logError(message);
    }

    public static void registerClassRegistry(Class registryClass) {
        try {
            Method method = registryClass.getMethod("getClasses", List.class);
            if ((method.getModifiers() & 8) == 0) {
                System.out.println("ERROR: getClasses method in " + registryClass.getName() + " isn't static");
            } else {
                ArrayList classes = new ArrayList();
                method.invoke(null, classes);
                block4: for (Class cls : classes) {
                    for (Annotation annotation : cls.getAnnotations()) {
                        String[] value;
                        if (!(annotation instanceof ModOnly)) continue;
                        for (String mod : value = ((ModOnly)annotation).value()) {
                            if (!loadedMods.contains(mod)) continue block4;
                        }
                    }
                    MineTweakerAPI.registerClass(cls);
                }
            }
        }
        catch (NoSuchMethodException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public static boolean registerClassRegistry(String className) {
        try {
            MineTweakerAPI.registerClassRegistry(Class.forName(className));
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static void registerClass(Class annotatedClass) {
        for (Annotation annotation : annotatedClass.getAnnotations()) {
            if (annotation instanceof ZenExpansion) {
                GlobalRegistry.registerExpansion(annotatedClass);
            }
            if (annotation instanceof ZenClass) {
                GlobalRegistry.registerNativeClass(annotatedClass);
            }
            if (!(annotation instanceof BracketHandler) || !IBracketHandler.class.isAssignableFrom(annotatedClass)) continue;
            try {
                IBracketHandler bracketHandler = (IBracketHandler)annotatedClass.newInstance();
                MineTweakerAPI.registerBracketHandler(bracketHandler);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(MineTweakerAPI.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(MineTweakerAPI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void registerGlobalSymbol(String name, IZenSymbol symbol) {
        GlobalRegistry.registerGlobal(name, symbol);
    }

    public static void registerRemover(IRecipeRemover remover) {
        GlobalRegistry.registerRemover(remover);
    }

    public static void registerBracketHandler(IBracketHandler handler) {
        GlobalRegistry.registerBracketHandler(handler);
    }

    public static IZenSymbol getJavaStaticMethodSymbol(Class cls, String name, Class ... arguments) {
        JavaMethod method = JavaMethod.get(GlobalRegistry.getTypeRegistry(), cls, name, arguments);
        return new SymbolJavaStaticMethod(method);
    }

    public static IZenSymbol getJavaStaticGetterSymbol(Class cls, String name) {
        JavaMethod method = JavaMethod.get(GlobalRegistry.getTypeRegistry(), cls, name, new Class[0]);
        return new SymbolJavaStaticGetter(method);
    }

    public static IZenSymbol getJavaStaticFieldSymbol(Class cls, String name) {
        try {
            Field field = cls.getField(name);
            return new SymbolJavaStaticField(cls, field, GlobalRegistry.getTypeRegistry());
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static JavaMethod getJavaMethod(Class cls, String name, Class ... arguments) {
        return JavaMethod.get(GlobalRegistry.getTypeRegistry(), cls, name, arguments);
    }

    static {
        ArrayList apiClasses = new ArrayList();
        ClassRegistry.getClasses(apiClasses);
        for (Class cls : apiClasses) {
            MineTweakerAPI.registerClass(cls);
        }
        MineTweakerAPI.registerGlobalSymbol("logger", MineTweakerAPI.getJavaStaticGetterSymbol(MineTweakerAPI.class, "getLogger"));
        MineTweakerAPI.registerGlobalSymbol("recipes", MineTweakerAPI.getJavaStaticFieldSymbol(MineTweakerAPI.class, "recipes"));
        MineTweakerAPI.registerGlobalSymbol("furnace", MineTweakerAPI.getJavaStaticFieldSymbol(MineTweakerAPI.class, "furnace"));
        MineTweakerAPI.registerGlobalSymbol("oreDict", MineTweakerAPI.getJavaStaticFieldSymbol(MineTweakerAPI.class, "oreDict"));
        MineTweakerAPI.registerGlobalSymbol("events", MineTweakerAPI.getJavaStaticFieldSymbol(MineTweakerAPI.class, "events"));
        MineTweakerAPI.registerGlobalSymbol("server", MineTweakerAPI.getJavaStaticFieldSymbol(MineTweakerAPI.class, "server"));
        MineTweakerAPI.registerGlobalSymbol("client", MineTweakerAPI.getJavaStaticFieldSymbol(MineTweakerAPI.class, "client"));
        MineTweakerAPI.registerGlobalSymbol("game", MineTweakerAPI.getJavaStaticFieldSymbol(MineTweakerAPI.class, "game"));
        MineTweakerAPI.registerGlobalSymbol("loadedMods", MineTweakerAPI.getJavaStaticFieldSymbol(MineTweakerAPI.class, "loadedMods"));
        tweaker = new MTTweaker();
        oreDict = null;
        recipes = null;
        furnace = null;
        events = MineTweakerImplementationAPI.events;
        server = null;
        client = null;
        game = null;
        loadedMods = null;
    }
}

