/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.event;

import minetweaker.api.block.IBlock;
import minetweaker.api.entity.IEntity;
import minetweaker.api.player.IPlayer;
import minetweaker.api.world.IBlockGroup;
import minetweaker.api.world.IDimension;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="minetweaker.event.PlayerInteractEvent")
public class PlayerInteractEvent {
    private final IPlayer player;
    private final IEntity entity;
    private final IBlockGroup blocks;
    private final int x;
    private final int y;
    private final int z;
    private boolean canceled;
    private boolean useBlock;
    private boolean useItem;

    public PlayerInteractEvent(IPlayer player, IEntity entity, IBlockGroup blocks, int x, int y, int z) {
        this.player = player;
        this.entity = entity;
        this.blocks = blocks;
        this.x = x;
        this.y = y;
        this.z = z;
        this.canceled = false;
        this.useBlock = false;
        this.useItem = false;
    }

    @ZenMethod
    public void cancel() {
        this.canceled = true;
    }

    @ZenMethod
    public void useBlock() {
        this.useBlock = true;
    }

    @ZenMethod
    public void useItem() {
        this.useItem = true;
    }

    @ZenGetter(value="canceled")
    public boolean isCanceled() {
        return this.canceled;
    }

    @ZenGetter(value="usingBlock")
    public boolean isUsingBlock() {
        return this.useBlock;
    }

    @ZenGetter(value="usingItem")
    public boolean isUsingItem() {
        return this.useItem;
    }

    @ZenGetter(value="player")
    public IPlayer getPlayer() {
        return this.player;
    }

    @ZenGetter(value="blocks")
    public IBlockGroup getBlocks() {
        return this.blocks;
    }

    @ZenGetter(value="x")
    public int getX() {
        return this.x;
    }

    @ZenGetter(value="y")
    public int getY() {
        return this.y;
    }

    @ZenGetter(value="z")
    public int getZ() {
        return this.z;
    }

    @ZenGetter(value="block")
    public IBlock getBlock() {
        return this.blocks.getBlock(this.x, this.y, this.z);
    }

    @ZenGetter(value="dimension")
    public IDimension getDimension() {
        return this.blocks.getDimension();
    }
}

