/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import minetweaker.runtime.ILogger;

public class FileLogger
implements ILogger {
    private final Writer writer;

    public FileLogger(File output) {
        try {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("What the heck?");
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("File not found");
        }
    }

    @Override
    public void logCommand(String message) {
        try {
            this.writer.write("COMMAND: " + message + "\n");
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void logInfo(String message) {
        try {
            this.writer.write("INFO: " + message + "\n");
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void logWarning(String message) {
        try {
            this.writer.write("WARNING: " + message + "\n");
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void logError(String message) {
        try {
            this.writer.write("ERROR: " + message + "\n");
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

