/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.brackets;

import java.util.List;
import minetweaker.IBracketHandler;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.BracketHandler;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.expression.ExpressionInt;
import stanhebben.zenscript.expression.ExpressionJavaCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler(priority=100)
public class ItemBracketHandler
implements IBracketHandler {
    private final IZenSymbol symbolAny = MineTweakerAPI.getJavaStaticFieldSymbol(IngredientAny.class, "INSTANCE");
    private final JavaMethod method = MineTweakerAPI.getJavaMethod(ItemBracketHandler.class, "getItem", String.class, Integer.TYPE);

    public static IItemStack getItem(String name, int meta) {
        Item item = (Item)Item.field_150901_e.func_82594_a(name);
        if (item != null) {
            return new MCItemStack(new ItemStack(item, 1, meta), true);
        }
        return null;
    }

    @Override
    public IZenSymbol resolve(List<Token> tokens) {
        if (tokens.size() == 1 && tokens.get(0).getValue().equals("*")) {
            return this.symbolAny;
        }
        int fromIndex = 0;
        int toIndex = tokens.size();
        int meta = 0;
        if (tokens.size() > 2) {
            if (tokens.get(0).getValue().equals("item") && tokens.get(1).getValue().equals(":")) {
                fromIndex = 2;
            }
            if (tokens.get(tokens.size() - 1).getType() == 2 && tokens.get(tokens.size() - 2).getValue().equals(":")) {
                toIndex = tokens.size() - 2;
                meta = Integer.parseInt(tokens.get(tokens.size() - 1).getValue());
            } else if (tokens.get(tokens.size() - 1).getValue().equals("*") && tokens.get(tokens.size() - 2).getValue().equals(":")) {
                toIndex = tokens.size() - 2;
                meta = Short.MAX_VALUE;
            }
        }
        return this.find(tokens, fromIndex, toIndex, meta);
    }

    private IZenSymbol find(List<Token> tokens, int startIndex, int endIndex, int meta) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        Item item = (Item)Item.field_150901_e.func_82594_a(valueBuilder.toString());
        if (item != null) {
            return new ItemReferenceSymbol(valueBuilder.toString(), meta);
        }
        return null;
    }

    private class ItemReferenceSymbol
    implements IZenSymbol {
        private final String name;
        private final int meta;

        public ItemReferenceSymbol(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            return new ExpressionJavaCallStatic(position, ItemBracketHandler.this.method, new ExpressionString(position, this.name), new ExpressionInt(position, this.meta, ZenType.INT));
        }
    }
}

