/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.furnace;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.furnace.SetFuelPattern;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.item.ItemStack;

public class FuelTweaker {
    public static final FuelTweaker INSTANCE = new FuelTweaker();
    private List<IFuelHandler> original;
    private final HashMap<String, List<SetFuelPattern>> quickList = new HashMap();

    private FuelTweaker() {
    }

    public void register() {
        try {
            Field fuelHandlers = GameRegistry.class.getDeclaredField("fuelHandlers");
            fuelHandlers.setAccessible(true);
            this.original = (List)fuelHandlers.get(null);
            ArrayList<OverridingFuelHandler> modified = new ArrayList<OverridingFuelHandler>();
            modified.add(new OverridingFuelHandler());
            fuelHandlers.set(null, modified);
        }
        catch (NoSuchFieldException ex) {
            System.out.println("[MineTweaker] Error: could not get GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
        catch (SecurityException ex) {
            System.out.println("[MineTweaker] Error: could not alter GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
        catch (IllegalAccessException ex) {
            System.out.println("[MineTweaker] Error: could not alter GameRegistry fuel handlers field. Cannot use custom fuel values.");
        }
    }

    public void addFuelPattern(SetFuelPattern pattern) {
        List<IItemStack> items = pattern.getPattern().getItems();
        if (items == null) {
            MineTweakerAPI.logError("Cannot set fuel for <*>");
            return;
        }
        for (IItemStack item : pattern.getPattern().getItems()) {
            if (!this.quickList.containsKey(item.getName())) {
                this.quickList.put(item.getName(), new ArrayList());
            }
            this.quickList.get(item.getName()).add(pattern);
        }
    }

    public void removeFuelPattern(SetFuelPattern pattern) {
        for (IItemStack item : pattern.getPattern().getItems()) {
            if (!this.quickList.containsKey(item.getName())) {
                this.quickList.put(item.getName(), new ArrayList());
            }
            this.quickList.get(item.getName()).add(pattern);
        }
    }

    private class OverridingFuelHandler
    implements IFuelHandler {
        private OverridingFuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            MCItemStack stack = new MCItemStack(fuel);
            String name = fuel.func_77977_a();
            if (FuelTweaker.this.quickList.containsKey(name)) {
                for (SetFuelPattern override : (List)FuelTweaker.this.quickList.get(name)) {
                    if (!override.getPattern().matches(stack)) continue;
                    return override.getValue();
                }
            }
            int max = 0;
            for (IFuelHandler handler : FuelTweaker.this.original) {
                max = Math.max(max, handler.getBurnTime(fuel));
            }
            return max;
        }
    }
}

