/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionJavaCallStatic
extends Expression {
    private final JavaMethod method;
    private final Expression[] arguments;

    public ExpressionJavaCallStatic(ZenPosition position, JavaMethod method, Expression ... arguments) {
        super(position);
        this.method = method;
        this.arguments = arguments;
    }

    @Override
    public ZenType getType() {
        return this.method.getReturnType();
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        MethodOutput output = environment.getOutput();
        for (Expression argument : this.arguments) {
            argument.compile(true, environment);
        }
        output.invokeStatic(this.method);
        if (this.method.getReturnType() != ZenType.VOID && !result) {
            output.pop(this.method.getReturnType().isLarge());
        }
    }
}

