/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionJavaCallVirtual
extends Expression {
    private final JavaMethod method;
    private final Expression receiver;
    private final Expression[] arguments;

    public ExpressionJavaCallVirtual(ZenPosition position, JavaMethod method, Expression receiver, Expression ... arguments) {
        super(position);
        this.method = method;
        this.receiver = receiver;
        this.arguments = arguments;
    }

    @Override
    public ZenType getType() {
        return this.method.getReturnType();
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        this.receiver.compile(true, environment);
        for (Expression argument : this.arguments) {
            argument.compile(true, environment);
        }
        environment.getOutput().invoke(this.method);
        if (this.method.getReturnType() != ZenType.VOID && !result) {
            environment.getOutput().pop(this.method.getReturnType().isLarge());
        }
    }
}

