/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression.partial;

import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionJavaCallStaticGenerated;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolZenStaticMethod;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class PartialStaticGenerated
implements IPartialExpression {
    private final ZenPosition position;
    private final String owner;
    private final String method;
    private final String signature;
    private final ZenType[] argumentTypes;
    private final ZenType returnType;

    public PartialStaticGenerated(ZenPosition position, String owner, String method, String signature, ZenType[] argumentTypes, ZenType returnType) {
        this.position = position;
        this.owner = owner;
        this.method = method;
        this.signature = signature;
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
    }

    @Override
    public Expression eval(IEnvironmentGlobal environment) {
        environment.error(this.position, "cannot use a function as value");
        return new ExpressionInvalid(this.position);
    }

    @Override
    public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
        environment.error(position, "cannot assign to a function");
        return new ExpressionInvalid(position);
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        environment.error(position, "functions don't have members");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
        if (values.length != this.argumentTypes.length) {
            environment.error(position, "invalid number of arguments");
            return new ExpressionInvalid(position);
        }
        Expression[] arguments = new Expression[this.argumentTypes.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = values[i].cast(position, environment, this.argumentTypes[i]);
        }
        return new ExpressionJavaCallStaticGenerated(position, this.owner, this.method, this.signature, this.returnType, arguments);
    }

    @Override
    public IZenSymbol toSymbol() {
        return new SymbolZenStaticMethod(this.owner, this.method, this.signature, this.argumentTypes, this.returnType);
    }

    @Override
    public ZenType toType(IEnvironmentGlobal environment) {
        environment.error(this.position, "not a valid type");
        return ZenType.ANY;
    }
}

