/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArrayGet;
import stanhebben.zenscript.expression.ExpressionArrayLength;
import stanhebben.zenscript.expression.ExpressionArraySet;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArray;
import stanhebben.zenscript.type.ZenTypeArrayList;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class ZenTypeArrayBasic
extends ZenTypeArray {
    private final Type asmType;

    public ZenTypeArrayBasic(ZenType base) {
        super(base);
        this.asmType = Type.getType((String)("[" + base.toASMType().getDescriptor()));
    }

    public boolean equals(Object other) {
        if (other instanceof ZenTypeArrayBasic) {
            ZenTypeArrayBasic o = (ZenTypeArrayBasic)other;
            return o.getBaseType().equals(this.getBaseType());
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.getBaseType() != null ? this.getBaseType().hashCode() : 0);
        return hash;
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, Expression value, ZenType type) {
        if (this.equals(type)) {
            return value;
        }
        return this.castExpansion(position, environment, value, type);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        if (numValues == 1) {
            return new ValueIterator(methodOutput.getOutput());
        }
        if (numValues == 2) {
            return new IndexValueIterator(methodOutput.getOutput());
        }
        return null;
    }

    @Override
    public Type toASMType() {
        return this.asmType;
    }

    @Override
    public Class toJavaClass() {
        try {
            return Class.forName("[" + this.getBaseType().toJavaClass().getName());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getSignature() {
        return "[" + this.getBaseType().getSignature();
    }

    @Override
    public void compileCast(ZenPosition position, IEnvironmentMethod environment, ZenType toClass) {
        MethodOutput output = environment.getOutput();
        if (!this.compileCastExpansion(position, environment, toClass)) {
            if (toClass instanceof ZenTypeArrayList) {
                output.invokeStatic(Arrays.class, "asList", List.class, Object[].class);
            } else if (toClass instanceof ZenTypeArrayBasic && !toClass.equals(this)) {
                ZenType component = ((ZenTypeArrayBasic)toClass).getBaseType();
                Type componentType = component.toASMType();
                int result = output.local(componentType);
                output.dup();
                output.arrayLength();
                output.newArray(componentType);
                output.storeObject(result);
                output.iConst0();
                Label lbl = new Label();
                output.label(lbl);
                output.dupX1();
                output.dupX1();
                output.arrayLoad(componentType);
                this.getBaseType().compileCast(position, environment, toClass);
                output.loadObject(result);
                output.dupX2();
                output.dupX2();
                output.arrayStore(componentType);
                output.pop();
                output.iConst1();
                output.iAdd();
                output.dupX1();
                output.arrayLength();
                output.ifICmpGE(lbl);
                output.pop();
                output.pop();
                output.loadObject(result);
            }
        }
    }

    @Override
    public IPartialExpression getMemberLength(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value) {
        return new ExpressionArrayLength(position, value.eval(environment));
    }

    @Override
    public Expression indexGet(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression index) {
        return new ExpressionArrayGet(position, array, index.cast(position, environment, INT));
    }

    @Override
    public Expression indexSet(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression index, Expression value) {
        return new ExpressionArraySet(position, array, index.cast(position, environment, INT), value.cast(position, environment, this.getBaseType()));
    }

    private class IndexValueIterator
    implements IZenIterator {
        private final MethodOutput methodOutput;

        public IndexValueIterator(MethodOutput methodOutput) {
            this.methodOutput = methodOutput;
        }

        @Override
        public void compileStart(int[] locals) {
            this.methodOutput.iConst0();
            this.methodOutput.storeInt(locals[0]);
        }

        @Override
        public void compilePreIterate(int[] locals, Label exit) {
            this.methodOutput.dup();
            this.methodOutput.arrayLength();
            this.methodOutput.loadInt(locals[0]);
            this.methodOutput.ifICmpGE(exit);
            this.methodOutput.dup();
            this.methodOutput.loadInt(locals[0]);
            this.methodOutput.arrayLoad(ZenTypeArrayBasic.this.getBaseType().toASMType());
            this.methodOutput.store(ZenTypeArrayBasic.this.getBaseType().toASMType(), locals[1]);
        }

        @Override
        public void compilePostIterate(int[] locals, Label exit, Label repeat) {
            this.methodOutput.iinc(locals[0]);
            this.methodOutput.goTo(repeat);
        }

        @Override
        public void compileEnd() {
            this.methodOutput.pop();
        }

        @Override
        public ZenType getType(int i) {
            return ZenTypeArrayBasic.this.getBaseType();
        }
    }

    private class ValueIterator
    implements IZenIterator {
        private final MethodOutput methodOutput;
        private int index;

        public ValueIterator(MethodOutput methodOutput) {
            this.methodOutput = methodOutput;
        }

        @Override
        public void compileStart(int[] locals) {
            this.index = this.methodOutput.local(Type.INT_TYPE);
            this.methodOutput.iConst0();
            this.methodOutput.storeInt(this.index);
        }

        @Override
        public void compilePreIterate(int[] locals, Label exit) {
            this.methodOutput.dup();
            this.methodOutput.arrayLength();
            this.methodOutput.loadInt(this.index);
            this.methodOutput.ifICmpGE(exit);
            this.methodOutput.dup();
            this.methodOutput.loadInt(this.index);
            this.methodOutput.arrayLoad(ZenTypeArrayBasic.this.getBaseType().toASMType());
            this.methodOutput.store(ZenTypeArrayBasic.this.getBaseType().toASMType(), locals[0]);
        }

        @Override
        public void compilePostIterate(int[] locals, Label exit, Label repeat) {
            this.methodOutput.iinc(this.index, 1);
            this.methodOutput.goTo(repeat);
        }

        @Override
        public void compileEnd() {
            this.methodOutput.pop();
        }

        @Override
        public ZenType getType(int i) {
            return ZenTypeArrayBasic.this.getBaseType();
        }
    }
}

