/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeArray;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.type.ZenTypeInt;
import stanhebben.zenscript.type.iterator.IteratorIterable;
import stanhebben.zenscript.type.iterator.IteratorList;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ZenTypeArrayList
extends ZenTypeArray {
    private final Type type = Type.getType(List.class);

    public ZenTypeArrayList(ZenType baseType) {
        super(baseType);
    }

    @Override
    public IPartialExpression getMemberLength(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value) {
        return new ExpressionListLength(position, value.eval(environment));
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, Expression value, ZenType type) {
        if (this.equals(type)) {
            return value;
        }
        return this.castExpansion(position, environment, value, type);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        if (numValues == 1) {
            return new IteratorIterable(methodOutput.getOutput(), this.getBaseType());
        }
        if (numValues == 2) {
            return new IteratorList(methodOutput.getOutput(), this.getBaseType());
        }
        return null;
    }

    @Override
    public Class toJavaClass() {
        return List.class;
    }

    @Override
    public Type toASMType() {
        return Type.getType(List.class);
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(List.class);
    }

    @Override
    public void compileCast(ZenPosition position, IEnvironmentMethod environment, ZenType type) {
        MethodOutput output = environment.getOutput();
        if (this.equals(type)) {
            return;
        }
        if (!this.compileCastExpansion(position, environment, type) && !(type instanceof ZenTypeArrayList) && type instanceof ZenTypeArrayBasic) {
            ZenType component = ((ZenTypeArrayBasic)type).getBaseType();
            Type componentType = component.toASMType();
            Type baseType = this.getBaseType().toASMType();
            int result = output.local(componentType);
            output.dup();
            output.arrayLength();
            output.newArray(baseType);
            output.storeObject(result);
            output.iConst0();
            Label lbl = new Label();
            output.label(lbl);
            output.dupX1();
            output.dupX1();
            output.arrayLoad(componentType);
            this.getBaseType().compileCast(position, environment, type);
            output.loadObject(result);
            output.dupX2();
            output.dupX2();
            output.arrayStore(baseType);
            output.pop();
            output.iConst1();
            output.iAdd();
            output.dupX1();
            output.arrayLength();
            output.ifICmpGE(lbl);
            output.pop();
            output.pop();
            output.loadObject(result);
        }
    }

    @Override
    public Expression indexGet(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Expression indexSet(ZenPosition position, IEnvironmentGlobal environment, Expression array, Expression index, Expression value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class ExpressionListLength
    extends Expression {
        private final Expression value;

        public ExpressionListLength(ZenPosition position, Expression value) {
            super(position);
            this.value = value;
        }

        @Override
        public ZenType getType() {
            return ZenTypeInt.INSTANCE;
        }

        @Override
        public void compile(boolean result, IEnvironmentMethod environment) {
            this.value.compile(result, environment);
            if (result) {
                environment.getOutput().invokeInterface(List.class, "size", Integer.TYPE, new Class[0]);
            }
        }
    }
}

