/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.data;

import java.util.List;
import java.util.Map;
import minetweaker.api.data.IData;
import minetweaker.api.data.IDataConverter;

public class DataFloat
implements IData {
    private final float value;

    public DataFloat(float value) {
        this.value = value;
    }

    @Override
    public boolean asBool() {
        throw new RuntimeException("Cannot cast a float to a bool");
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInt() {
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return (long)this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public String asString() {
        return Float.toString(this.value);
    }

    @Override
    public List<IData> asList() {
        throw new UnsupportedOperationException("Cannot cast a float to a list");
    }

    @Override
    public Map<String, IData> asMap() {
        throw new UnsupportedOperationException("Cannot cast a float to a map");
    }

    @Override
    public byte[] asByteArray() {
        throw new RuntimeException("Cannot cast a float to a byte array");
    }

    @Override
    public int[] asIntArray() {
        throw new RuntimeException("Cannot cast a float to an int array");
    }

    @Override
    public IData getAt(int i) {
        throw new RuntimeException("A float is not indexable");
    }

    @Override
    public void setAt(int i, IData value) {
        throw new RuntimeException("A float is not indexable");
    }

    @Override
    public IData memberGet(String name) {
        throw new RuntimeException("A float is not indexable");
    }

    @Override
    public void memberSet(String name, IData data) {
        throw new RuntimeException("A float is not indexable");
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public boolean contains(IData data) {
        return data.asFloat() == this.value;
    }

    @Override
    public boolean equals(IData data) {
        return this.value == data.asFloat();
    }

    @Override
    public int compareTo(IData data) {
        return Float.compare(this.value, data.asFloat());
    }

    @Override
    public IData immutable() {
        return this;
    }

    @Override
    public IData update(IData data) {
        return data;
    }

    @Override
    public <T> T convert(IDataConverter<T> converter) {
        return converter.fromFloat(this.value);
    }

    @Override
    public IData add(IData other) {
        return new DataFloat(this.value + other.asFloat());
    }

    @Override
    public IData sub(IData other) {
        return new DataFloat(this.value - other.asFloat());
    }

    @Override
    public IData mul(IData other) {
        return new DataFloat(this.value * other.asFloat());
    }

    @Override
    public IData div(IData other) {
        return new DataFloat(this.value / other.asFloat());
    }

    @Override
    public IData mod(IData other) {
        return new DataFloat(this.value % other.asFloat());
    }

    @Override
    public IData and(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise operations on float");
    }

    @Override
    public IData or(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise operations on float");
    }

    @Override
    public IData xor(IData other) {
        throw new UnsupportedOperationException("Cannot perform bitwise operations on float");
    }

    @Override
    public IData neg() {
        return new DataFloat(-this.value);
    }

    @Override
    public IData not() {
        throw new UnsupportedOperationException("Cannot perform bitwise operations on float");
    }

    @Override
    public String toString() {
        return this.asString() + " as float";
    }
}

