/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import minetweaker.api.data.IData;
import minetweaker.api.data.IDataConverter;

public class DataList
implements IData {
    private final List<IData> values;
    private final boolean immutable;

    public DataList(List<IData> values, boolean immutable) {
        this.values = values;
        this.immutable = immutable;
    }

    @Override
    public boolean asBool() {
        throw new RuntimeException("Cannot convert a list to a bool");
    }

    @Override
    public byte asByte() {
        throw new RuntimeException("Cannot convert a list to a byte");
    }

    @Override
    public short asShort() {
        throw new RuntimeException("Cannot convert a list to a short");
    }

    @Override
    public int asInt() {
        throw new RuntimeException("Cannot convert a list to an int");
    }

    @Override
    public long asLong() {
        throw new RuntimeException("Cannot convert a list to a long");
    }

    @Override
    public float asFloat() {
        throw new RuntimeException("Cannot convert a list to a float");
    }

    @Override
    public double asDouble() {
        throw new RuntimeException("Cannot convert a list to a double");
    }

    @Override
    public List<IData> asList() {
        if (this.immutable) {
            return Collections.unmodifiableList(this.values);
        }
        return this.values;
    }

    @Override
    public Map<String, IData> asMap() {
        throw new RuntimeException("Cannot convert a list to a map");
    }

    @Override
    public String asString() {
        StringBuilder output = new StringBuilder();
        output.append('[');
        boolean first = true;
        for (IData value : this.values) {
            if (first) {
                first = false;
            } else {
                output.append(", ");
            }
            output.append(value.toString());
        }
        output.append(']');
        return output.toString();
    }

    @Override
    public byte[] asByteArray() {
        byte[] result = new byte[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            result[i] = this.values.get(i).asByte();
        }
        return result;
    }

    @Override
    public int[] asIntArray() {
        int[] result = new int[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            result[i] = this.values.get(i).asInt();
        }
        return result;
    }

    @Override
    public IData getAt(int i) {
        return this.values.get(i);
    }

    @Override
    public void setAt(int i, IData value) {
        if (this.immutable) {
            throw new RuntimeException("this list is immutable");
        }
        this.values.set(i, value);
    }

    @Override
    public IData memberGet(String name) {
        throw new RuntimeException("Lists don't have members");
    }

    @Override
    public void memberSet(String name, IData data) {
        throw new RuntimeException("Lists don't have members");
    }

    @Override
    public int length() {
        return this.values.size();
    }

    @Override
    public boolean contains(IData data) {
        for (IData value : this.values) {
            if (!value.equals(data)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(IData data) {
        List<IData> otherValues = data.asList();
        if (otherValues.size() != this.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i).equals(otherValues.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(IData data) {
        throw new UnsupportedOperationException("Cannot compare with a list");
    }

    @Override
    public IData immutable() {
        if (this.immutable) {
            return this;
        }
        ArrayList<IData> copy = new ArrayList<IData>();
        for (IData value : this.values) {
            copy.add(value.immutable());
        }
        return new DataList(copy, true);
    }

    @Override
    public IData update(IData data) {
        if (this.immutable) {
            data = data.immutable();
        }
        ArrayList<IData> result = new ArrayList<IData>();
        result.addAll(this.values);
        result.addAll(data.asList());
        return new DataList(result, this.immutable);
    }

    @Override
    public <T> T convert(IDataConverter<T> converter) {
        return converter.fromList(this.values);
    }

    @Override
    public IData add(IData other) {
        return this.update(other);
    }

    @Override
    public IData sub(IData other) {
        throw new UnsupportedOperationException("Cannot subtract from a list");
    }

    @Override
    public IData mul(IData other) {
        throw new UnsupportedOperationException("Cannot multiply a list");
    }

    @Override
    public IData div(IData other) {
        throw new UnsupportedOperationException("Cannot divide a list");
    }

    @Override
    public IData mod(IData other) {
        throw new UnsupportedOperationException("Cannot perform modulo on a list");
    }

    @Override
    public IData and(IData other) {
        throw new UnsupportedOperationException("Lists don't support bitwise operators");
    }

    @Override
    public IData or(IData other) {
        throw new UnsupportedOperationException("Lists don't support bitwise operators");
    }

    @Override
    public IData xor(IData other) {
        throw new UnsupportedOperationException("Lists don't support bitwise operators");
    }

    @Override
    public IData neg() {
        throw new UnsupportedOperationException("Cannot negate a list");
    }

    @Override
    public IData not() {
        throw new UnsupportedOperationException("Lists don't support bitwise operators");
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

