/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.minecraft;

import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.api.data.IData;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.player.IPlayer;
import minetweaker.mc1710.data.NBTConverter;
import minetweaker.mc1710.item.MCItemStack;
import minetweaker.mc1710.oredict.MCOreDictEntry;
import minetweaker.mc1710.player.MCPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MineTweakerMC {
    private MineTweakerMC() {
    }

    public static ItemStack getItemStack(IItemStack item) {
        if (item == null) {
            return null;
        }
        Object internal = item.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            MineTweakerAPI.logError("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    public static ItemStack getItemStack(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        List<IItemStack> items = ingredient.getItems();
        if (items.size() != 1) {
            MineTweakerAPI.logError("Not an ingredient with a single item: " + ingredient);
        }
        return MineTweakerMC.getItemStack(items.get(0));
    }

    public static IItemStack getIItemStack(ItemStack item) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(item);
    }

    public static IItemStack getIItemStackWildcardSize(ItemStack item) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(item, true);
    }

    public static IItemStack getIItemStackWildcardSize(Item item, int meta) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, 1, meta), true);
    }

    public static IItemStack getIItemStackWildcard(Item item, int amount) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, 1, Short.MAX_VALUE));
    }

    public static IItemStack getItemStack(Item item, int amount, int damage) {
        if (item == null) {
            return null;
        }
        return new MCItemStack(new ItemStack(item, amount, damage));
    }

    public static ItemStack[] getItemStacks(IItemStack ... items) {
        if (items == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            Object internal = items[i].getInternal();
            if (internal == null || !(internal instanceof ItemStack)) continue;
            output[i] = (ItemStack)internal;
        }
        return output;
    }

    public static ItemStack[] getItemStacks(List<IItemStack> items) {
        if (items == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            Object internal = items.get(i).getInternal();
            if (internal != null && internal instanceof ItemStack) {
                output[i] = (ItemStack)internal;
                continue;
            }
            MineTweakerAPI.logError("Invalid item stack: " + items.get(i));
        }
        return output;
    }

    public static IItemStack[] getIItemStacks(ItemStack ... items) {
        if (items == null) {
            return null;
        }
        IItemStack[] result = new IItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            result[i] = new MCItemStack(items[i]);
        }
        return result;
    }

    public static IItemStack[] getIItemStacks(List<ItemStack> items) {
        if (items == null) {
            return null;
        }
        IItemStack[] result = new IItemStack[items.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new MCItemStack(items.get(i));
        }
        return result;
    }

    public static IOreDictEntry getOreDict(String name) {
        return new MCOreDictEntry(name);
    }

    public static IPlayer getIPlayer(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return new MCPlayer(player);
    }

    public static EntityPlayer getPlayer(IPlayer player) {
        if (player == null) {
            return null;
        }
        if (!(player instanceof MCPlayer)) {
            MineTweakerAPI.logError("Invalid player: " + player);
        }
        return ((MCPlayer)player).getInternal();
    }

    public static IData getIData(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        return NBTConverter.from(nbt, true);
    }

    public static IData getIDataModifyable(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        return NBTConverter.from(nbt, false);
    }

    public static NBTBase getNBT(IData data) {
        if (data == null) {
            return null;
        }
        return NBTConverter.from(data);
    }

    public static NBTTagCompound getNBTCompound(IData data) {
        if (data == null) {
            return null;
        }
        return (NBTTagCompound)NBTConverter.from(data);
    }
}

