/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.logger.FileLogger;
import minetweaker.mc1710.FMLEventHandler;
import minetweaker.mc1710.MCPlatformFunctions;
import minetweaker.mc1710.MineTweakerRegistry;
import minetweaker.mc1710.furnace.FuelTweaker;
import minetweaker.mc1710.furnace.MCFurnaceManager;
import minetweaker.mc1710.game.MCGame;
import minetweaker.mc1710.mods.MCLoadedMods;
import minetweaker.mc1710.network.MineTweakerLoadScriptsHandler;
import minetweaker.mc1710.network.MineTweakerLoadScriptsPacket;
import minetweaker.mc1710.network.MineTweakerOpenBrowserHandler;
import minetweaker.mc1710.network.MineTweakerOpenBrowserPacket;
import minetweaker.mc1710.oredict.MCOreDict;
import minetweaker.mc1710.recipes.MCRecipeManager;
import minetweaker.mc1710.server.MCServer;
import minetweaker.mc1710.util.MineTweakerHacks;
import minetweaker.runtime.IScriptProvider;
import minetweaker.runtime.providers.ScriptProviderCascade;
import minetweaker.runtime.providers.ScriptProviderDirectory;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="MineTweaker3", version="1.7.10-3.0.3")
public class MineTweakerMod {
    public static final String MODID = "MineTweaker3";
    public static final String MCVERSION = "1.7.10";
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("MineTweaker3");
    private static final String[] REGISTRIES = new String[]{"minetweaker.mods.ic2.ClassRegistry", "minetweaker.mods.nei.ClassRegistry"};
    @Mod.Instance(value="MineTweaker3")
    public static MineTweakerMod INSTANCE;
    public final MCRecipeManager recipes;
    private final IScriptProvider scriptsGlobal;

    public MineTweakerMod() {
        MineTweakerAPI.oreDict = new MCOreDict();
        this.recipes = new MCRecipeManager();
        MineTweakerAPI.recipes = this.recipes;
        MineTweakerImplementationAPI.logger.addLogger(new FileLogger(new File("minetweaker.log")));
        MineTweakerAPI.game = MCGame.INSTANCE;
        MineTweakerAPI.furnace = new MCFurnaceManager();
        MineTweakerAPI.loadedMods = new MCLoadedMods();
        MineTweakerImplementationAPI.platform = MCPlatformFunctions.INSTANCE;
        File globalDir = new File("scripts");
        if (!globalDir.exists()) {
            globalDir.mkdirs();
        }
        this.scriptsGlobal = new ScriptProviderDirectory(globalDir);
        MineTweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
    }

    @Mod.EventHandler
    public void onLoad(FMLPreInitializationEvent ev) {
        MinecraftForge.EVENT_BUS.register((Object)new FMLEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandler());
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent ev) {
        MineTweakerAPI.registerClassRegistry(MineTweakerRegistry.class);
        for (String registry : REGISTRIES) {
            MineTweakerAPI.registerClassRegistry(registry);
        }
        FuelTweaker.INSTANCE.register();
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent ev) {
        File scriptsDir = new File(MineTweakerHacks.getWorldDirectory(ev.getServer()), "scripts");
        if (!scriptsDir.exists()) {
            scriptsDir.mkdir();
        }
        ScriptProviderDirectory scriptsLocal = new ScriptProviderDirectory(scriptsDir);
        ScriptProviderCascade cascaded = new ScriptProviderCascade(this.scriptsGlobal, scriptsLocal);
        MineTweakerImplementationAPI.setScriptProvider(cascaded);
        MineTweakerImplementationAPI.onServerStart(new MCServer(ev.getServer()));
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent ev) {
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent ev) {
        MineTweakerImplementationAPI.onServerStop();
        MineTweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
    }

    static {
        NETWORK.registerMessage(MineTweakerLoadScriptsHandler.class, MineTweakerLoadScriptsPacket.class, 0, Side.CLIENT);
        NETWORK.registerMessage(MineTweakerOpenBrowserHandler.class, MineTweakerOpenBrowserPacket.class, 1, Side.CLIENT);
    }
}

