/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.oredict;

import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.api.item.IngredientStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.oredict.IngredientOreDict;
import minetweaker.mc1710.util.MineTweakerHacks;
import minetweaker.util.ArrayUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MCOreDictEntry
implements IOreDictEntry {
    private static final List<ArrayList<ItemStack>> OREDICT_CONTENTS = MineTweakerHacks.getOreIdStacks();
    private static final List<ArrayList<ItemStack>> OREDICT_CONTENTS_UN = MineTweakerHacks.getOreIdStacksUn();
    private final int id;

    public MCOreDictEntry(Integer id) {
        this.id = id;
    }

    public MCOreDictEntry(String id) {
        this.id = OreDictionary.getOreID((String)id);
    }

    @Override
    public String getName() {
        return OreDictionary.getOreName((int)this.id);
    }

    @Override
    public boolean isEmpty() {
        return OreDictionary.getOres((Integer)this.id).isEmpty();
    }

    @Override
    public void add(IItemStack item) {
        ItemStack stack = MineTweakerMC.getItemStack(item);
        if (stack != null) {
            MineTweakerAPI.apply(new ActionAddItem(this.id, stack));
        }
    }

    @Override
    public void addAll(IOreDictEntry entry) {
        if (entry instanceof MCOreDictEntry) {
            MineTweakerAPI.apply(new ActionAddAll(this.id, ((MCOreDictEntry)entry).id));
        } else {
            MineTweakerAPI.logError("not a valid entry");
        }
    }

    @Override
    public void remove(IItemStack item) {
        ItemStack result = null;
        for (ItemStack itemStack : OreDictionary.getOres((Integer)this.id)) {
            if (!item.matches(MineTweakerMC.getIItemStackWildcardSize(itemStack))) continue;
            result = itemStack;
            break;
        }
        if (result != null) {
            MineTweakerAPI.apply(new ActionRemoveItem(this.id, result));
        }
    }

    @Override
    public boolean contains(IItemStack item) {
        for (ItemStack itemStack : OreDictionary.getOres((Integer)this.id)) {
            if (!MineTweakerMC.getIItemStackWildcardSize(itemStack).matches(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mirror(IOreDictEntry other) {
        if (other instanceof MCOreDictEntry) {
            MineTweakerAPI.apply(new ActionMirror(this.id, ((MCOreDictEntry)other).id));
        } else {
            MineTweakerAPI.logError("not a valid oredict entry");
        }
    }

    @Override
    public String getMark() {
        return null;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public List<IItemStack> getItems() {
        ArrayList<IItemStack> result = new ArrayList<IItemStack>();
        for (ItemStack item : OreDictionary.getOres((Integer)this.id)) {
            result.add(MineTweakerMC.getIItemStackWildcardSize(item));
        }
        return result;
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this, amount);
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientOreDict(this, null, ArrayUtil.EMPTY_CONDITIONS, new IItemTransformer[]{transformer});
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientOreDict(this, null, new IItemCondition[]{condition}, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientOreDict(this, mark, ArrayUtil.EMPTY_CONDITIONS, ArrayUtil.EMPTY_TRANSFORMERS);
    }

    @Override
    public boolean matches(IItemStack item) {
        return this.contains(item);
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> items = ingredient.getItems();
        for (IItemStack item : items) {
            if (this.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item) {
        return item;
    }

    @Override
    public boolean hasTransformers() {
        return false;
    }

    @Override
    public Object getInternal() {
        return OreDictionary.getOreName((int)this.id);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MCOreDictEntry)) {
            return false;
        }
        return ((MCOreDictEntry)other).id == this.id;
    }

    private static class ActionAddAll
    implements IUndoableAction {
        private final Integer idTarget;
        private final Integer idSource;

        public ActionAddAll(Integer idTarget, Integer idSource) {
            this.idTarget = idTarget;
            this.idSource = idSource;
        }

        @Override
        public void apply() {
            ArrayList ores = OreDictionary.getOres((Integer)this.idTarget);
            for (ItemStack stack : OreDictionary.getOres((Integer)this.idSource)) {
                ores.add(stack);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            ArrayList ores = OreDictionary.getOres((Integer)this.idTarget);
            for (ItemStack stack : OreDictionary.getOres((Integer)this.idSource)) {
                ores.remove(stack);
            }
        }

        @Override
        public String describe() {
            return "Copying contents of ore dictionary entry " + OreDictionary.getOreName((int)this.idSource) + " to " + OreDictionary.getOreName((int)this.idTarget);
        }

        @Override
        public String describeUndo() {
            return "Removing contents of ore dictionary entry " + OreDictionary.getOreName((int)this.idSource) + " from " + OreDictionary.getOreName((int)this.idTarget);
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionRemoveItem
    implements IUndoableAction {
        private final Integer id;
        private final ItemStack item;

        public ActionRemoveItem(Integer id, ItemStack item) {
            this.id = id;
            this.item = item;
        }

        @Override
        public void apply() {
            ((ArrayList)OREDICT_CONTENTS.get(this.id)).remove(this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            ((ArrayList)OREDICT_CONTENTS.get(this.id)).add(this.item);
        }

        @Override
        public String describe() {
            return "Removing " + this.item.func_82833_r() + " from ore dictionary entry " + OreDictionary.getOreName((int)this.id);
        }

        @Override
        public String describeUndo() {
            return "Restoring " + this.item.func_82833_r() + " to ore dictionary entry " + OreDictionary.getOreName((int)this.id);
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionMirror
    implements IUndoableAction {
        private final Integer idTarget;
        private final Integer idSource;
        private final ArrayList<ItemStack> targetCopy;
        private final ArrayList<ItemStack> targetCopyUn;

        public ActionMirror(Integer idTarget, Integer idSource) {
            this.idTarget = idTarget;
            this.idSource = idSource;
            this.targetCopy = (ArrayList)OREDICT_CONTENTS.get(idTarget);
            this.targetCopyUn = (ArrayList)OREDICT_CONTENTS_UN.get(idTarget);
        }

        @Override
        public void apply() {
            OREDICT_CONTENTS.set(this.idTarget, OREDICT_CONTENTS.get(this.idSource));
            OREDICT_CONTENTS_UN.set(this.idTarget, OREDICT_CONTENTS_UN.get(this.idSource));
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            OREDICT_CONTENTS.set(this.idTarget, this.targetCopy);
            OREDICT_CONTENTS_UN.set(this.idTarget, this.targetCopyUn);
        }

        @Override
        public String describe() {
            return "Mirroring " + OreDictionary.getOreName((int)this.idSource) + " to " + OreDictionary.getOreName((int)this.idTarget);
        }

        @Override
        public String describeUndo() {
            return "Undoing mirror of " + OreDictionary.getOreName((int)this.idSource) + " to " + OreDictionary.getOreName((int)this.idTarget);
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class ActionAddItem
    implements IUndoableAction {
        private final Integer id;
        private final ItemStack item;

        public ActionAddItem(Integer id, ItemStack item) {
            this.id = id;
            this.item = item;
        }

        @Override
        public void apply() {
            OreDictionary.registerOre((int)this.id, (ItemStack)this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            ((ArrayList)OREDICT_CONTENTS.get(this.id)).remove(this.item);
        }

        @Override
        public String describe() {
            return "Adding " + this.item.func_82833_r() + " to ore dictionary entry " + OreDictionary.getOreName((int)this.id);
        }

        @Override
        public String describeUndo() {
            return "Removing " + this.item.func_82833_r() + " from ore dictionary entry " + OreDictionary.getOreName((int)this.id);
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

