/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.util;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import minetweaker.MineTweakerAPI;
import minetweaker.mc1710.util.MineTweakerObfuscation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class MineTweakerHacks {
    private static final Field NBTTAGLIST_TAGLIST = MineTweakerHacks.getField(NBTTagList.class, MineTweakerObfuscation.NBTTAGLIST_TAGLIST);
    private static final Field OREDICTIONARY_IDTOSTACK = MineTweakerHacks.getField(OreDictionary.class, MineTweakerObfuscation.OREDICTIONARY_IDTOSTACK);
    private static final Field OREDICTIONARY_IDTOSTACKUN = MineTweakerHacks.getField(OreDictionary.class, MineTweakerObfuscation.OREDICTIONARY_IDTOSTACKUN);
    private static final Field MINECRAFTSERVER_ANVILFILE = MineTweakerHacks.getField(MinecraftServer.class, MineTweakerObfuscation.MINECRAFTSERVER_ANVILFILE);
    private static final Field SHAPEDORERECIPE_WIDTH = MineTweakerHacks.getField(ShapedOreRecipe.class, new String[]{"width"});
    private static final Field INVENTORYCRAFTING_EVENTHANDLER = MineTweakerHacks.getField(InventoryCrafting.class, MineTweakerObfuscation.INVENTORYCRAFTING_EVENTHANDLER);
    private static final Field SLOTCRAFTING_PLAYER = MineTweakerHacks.getField(SlotCrafting.class, MineTweakerObfuscation.SLOTCRAFTING_PLAYER);

    private MineTweakerHacks() {
    }

    public static List<NBTBase> getTagList(NBTTagList list) {
        if (NBTTAGLIST_TAGLIST == null) {
            return null;
        }
        try {
            return (List)NBTTAGLIST_TAGLIST.get(list);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public static List<ArrayList<ItemStack>> getOreIdStacks() {
        try {
            return (List)OREDICTIONARY_IDTOSTACK.get(null);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("ERROR - could not load ore dictionary stacks!");
            return null;
        }
    }

    public static List<ArrayList<ItemStack>> getOreIdStacksUn() {
        try {
            return (List)OREDICTIONARY_IDTOSTACKUN.get(null);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("ERROR - could not load ore dictionary stacks!");
            return null;
        }
    }

    public static File getAnvilFile(MinecraftServer server) {
        try {
            return (File)MINECRAFTSERVER_ANVILFILE.get(server);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not load anvil file!");
            return null;
        }
    }

    public static File getWorldDirectory(MinecraftServer server) {
        if (server.func_71262_S()) {
            return server.func_71209_f("world");
        }
        File worldsDir = MineTweakerHacks.getAnvilFile(server);
        if (worldsDir == null) {
            return null;
        }
        return new File(worldsDir, server.func_71270_I());
    }

    public static int getShapedOreRecipeWidth(ShapedOreRecipe recipe) {
        try {
            return SHAPEDORERECIPE_WIDTH.getInt(recipe);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not load anvil file!");
            return 3;
        }
    }

    public static Container getCraftingContainer(InventoryCrafting inventory) {
        try {
            return (Container)INVENTORYCRAFTING_EVENTHANDLER.get(inventory);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not get inventory eventhandler");
            return null;
        }
    }

    public static EntityPlayer getCraftingSlotPlayer(SlotCrafting slot) {
        try {
            return (EntityPlayer)SLOTCRAFTING_PLAYER.get(slot);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not get inventory eventhandler");
            return null;
        }
    }

    public static StringTranslate getStringTranslateInstance() {
        try {
            Field field = MineTweakerHacks.getField(StringTranslate.class, MineTweakerObfuscation.STRINGTRANSLATE_INSTANCE);
            return (StringTranslate)field.get(null);
        }
        catch (IllegalAccessException ex) {
            MineTweakerAPI.logError("could not get string translator");
            return null;
        }
    }

    private static Field getField(Class cls, String[] names) {
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException ex) {
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        return null;
    }
}

