/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.expand;

import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemCondition;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import minetweaker.mods.ic2.expand.ItemExpansion;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="minetweaker.item.IIngredient")
@ModOnly(value={"IC2"})
public class IngredientExpansion {
    @ZenMethod
    public static IIngredient onlyIC2ChargeAtLeast(IIngredient ingredient, final int charge) {
        return ingredient.only(new IItemCondition(){

            @Override
            public boolean matches(IItemStack stack) {
                return ItemExpansion.getIC2Charge(stack) >= (double)charge;
            }
        });
    }

    @ZenMethod
    public static IIngredient onlyIC2ChargeAtMost(IIngredient ingredient, final int charge) {
        return ingredient.only(new IItemCondition(){

            @Override
            public boolean matches(IItemStack stack) {
                return ItemExpansion.getIC2Charge(stack) <= (double)charge;
            }
        });
    }

    @ZenMethod
    public static IIngredient transformIC2Discharge(IIngredient ingredient, final int amount) {
        return ingredient.transform(new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                return ItemExpansion.ic2Discharge(item, amount, 0).withAmount(item.getAmount() + 1);
            }
        });
    }
}

