/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import org.objectweb.asm.Label;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.ExpressionAs;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.expression.ParsedExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeBool;
import stanhebben.zenscript.util.ZenPosition;

public abstract class Expression
implements IPartialExpression {
    private final ZenPosition position;

    public static final Expression parse(ZenTokener parser, IEnvironmentMethod environment) {
        return ParsedExpression.read(parser, environment).compile(environment).eval(environment);
    }

    public Expression(ZenPosition position) {
        this.position = position;
    }

    public ZenPosition getPosition() {
        return this.position;
    }

    public abstract ZenType getType();

    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, ZenType type) {
        if (this.getType() == type) {
            return this;
        }
        if (this.getType().canCastImplicit(type, environment)) {
            return new ExpressionAs(position, this, type);
        }
        environment.error(position, "Cannot cast " + this.getType() + " to " + type);
        return new ExpressionInvalid(position, type);
    }

    public abstract void compile(boolean var1, IEnvironmentMethod var2);

    public void compileIf(Label onElse, IEnvironmentMethod environment) {
        if (this.getType() == ZenTypeBool.INSTANCE) {
            this.compile(true, environment);
            environment.getOutput().ifEQ(onElse);
        } else if (this.getType().isPointer()) {
            this.compile(true, environment);
            environment.getOutput().ifNull(onElse);
        } else {
            throw new RuntimeException("cannot compile non-pointer non-boolean value to if condition");
        }
    }

    @Override
    public Expression eval(IEnvironmentGlobal environment) {
        return this;
    }

    @Override
    public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
        environment.error(position, "not a valid lvalue");
        return new ExpressionInvalid(position, this.getType());
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return this.getType().getMember(position, environment, this, name);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
        return this.getType().call(position, environment, this, values);
    }

    @Override
    public IZenSymbol toSymbol() {
        return null;
    }

    @Override
    public ZenType toType(IEnvironmentGlobal environment) {
        environment.error(this.position, "not a valid type");
        return ZenType.ANY;
    }
}

