/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.statements;

import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.parser.expression.ParsedExpression;
import stanhebben.zenscript.statements.Statement;
import stanhebben.zenscript.util.ZenPosition;

public class StatementReturn
extends Statement {
    private final ParsedExpression expression;

    public StatementReturn(ZenPosition position, ParsedExpression expression) {
        super(position);
        this.expression = expression;
    }

    public ParsedExpression getExpression() {
        return this.expression;
    }

    @Override
    public boolean isReturn() {
        return false;
    }

    @Override
    public void compile(IEnvironmentMethod environment) {
        environment.getOutput().position(this.getPosition());
        if (this.expression == null) {
            environment.getOutput().ret();
        } else {
            Expression cExpression = this.expression.compile(environment).eval(environment);
            cExpression.compile(true, environment);
            Type returnType = cExpression.getType().toASMType();
            environment.getOutput().returnType(returnType);
        }
    }
}

