/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.io.IOException;
import org.objectweb.asm.Type;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.ParseException;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.type.ZenTypeAssociative;
import stanhebben.zenscript.type.ZenTypeBool;
import stanhebben.zenscript.type.ZenTypeByte;
import stanhebben.zenscript.type.ZenTypeDouble;
import stanhebben.zenscript.type.ZenTypeFloat;
import stanhebben.zenscript.type.ZenTypeInt;
import stanhebben.zenscript.type.ZenTypeLong;
import stanhebben.zenscript.type.ZenTypeNull;
import stanhebben.zenscript.type.ZenTypeShort;
import stanhebben.zenscript.type.ZenTypeString;
import stanhebben.zenscript.type.ZenTypeVoid;
import stanhebben.zenscript.type.expand.ZenExpandCaster;
import stanhebben.zenscript.util.ZenPosition;

public abstract class ZenType {
    public static final ZenTypeAny ANY = ZenTypeAny.INSTANCE;
    public static final ZenTypeBool BOOL = ZenTypeBool.INSTANCE;
    public static final ZenTypeByte BYTE = ZenTypeByte.INSTANCE;
    public static final ZenTypeShort SHORT = ZenTypeShort.INSTANCE;
    public static final ZenTypeInt INT = ZenTypeInt.INSTANCE;
    public static final ZenTypeLong LONG = ZenTypeLong.INSTANCE;
    public static final ZenTypeFloat FLOAT = ZenTypeFloat.INSTANCE;
    public static final ZenTypeDouble DOUBLE = ZenTypeDouble.INSTANCE;
    public static final ZenTypeString STRING = ZenTypeString.INSTANCE;
    public static final ZenTypeVoid VOID = ZenTypeVoid.INSTANCE;
    public static final ZenTypeNull NULL = ZenTypeNull.INSTANCE;
    public static final int NUM_BYTE = 1;
    public static final int NUM_SHORT = 2;
    public static final int NUM_INT = 3;
    public static final int NUM_LONG = 4;
    public static final int NUM_FLOAT = 5;
    public static final int NUM_DOUBLE = 6;

    public static ZenType parse(String type, IEnvironmentGlobal environment) {
        try {
            ZenTokener parser = new ZenTokener(type, environment.getEnvironment());
            return ZenType.read(parser, environment);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static ZenType read(ZenTokener parser, IEnvironmentGlobal environment) {
        ZenType base;
        Token next = parser.next();
        switch (next.getType()) {
            case 99: {
                base = ANY;
                break;
            }
            case 110: {
                base = VOID;
                break;
            }
            case 100: {
                base = BOOL;
                break;
            }
            case 101: {
                base = BYTE;
                break;
            }
            case 102: {
                base = SHORT;
                break;
            }
            case 103: {
                base = INT;
                break;
            }
            case 104: {
                base = LONG;
                break;
            }
            case 105: {
                base = FLOAT;
                break;
            }
            case 106: {
                base = DOUBLE;
                break;
            }
            case 107: {
                base = STRING;
                break;
            }
            case 1: {
                base = ANY;
                StringBuilder typeName = new StringBuilder();
                typeName.append(next.getValue());
                IPartialExpression partial = environment.getValue(next.getValue(), next.getPosition());
                while (parser.optional(10) != null) {
                    typeName.append('.');
                    Token member = parser.required(1, "identifier expected");
                    typeName.append(member.getValue());
                    if ((partial = partial.getMember(member.getPosition(), environment, member.getValue())) != null) continue;
                    environment.error(member.getPosition(), "could not find type " + typeName);
                    break;
                }
                if (partial == null) break;
                base = partial.toType(environment);
                System.out.println("Parsed type " + base.getName());
                break;
            }
            default: {
                throw new ParseException(next, "Unknown type: " + next.getValue());
            }
        }
        while (parser.optional(7) != null) {
            if (parser.optional(8) == null) {
                base = new ZenTypeAssociative(base, ZenType.read(parser, environment));
                parser.required(8, "] expected");
                continue;
            }
            base = new ZenTypeArrayBasic(base);
        }
        return base;
    }

    public abstract Expression unary(ZenPosition var1, IEnvironmentGlobal var2, Expression var3, OperatorType var4);

    public abstract Expression binary(ZenPosition var1, IEnvironmentGlobal var2, Expression var3, Expression var4, OperatorType var5);

    public abstract Expression trinary(ZenPosition var1, IEnvironmentGlobal var2, Expression var3, Expression var4, Expression var5, OperatorType var6);

    public abstract Expression compare(ZenPosition var1, IEnvironmentGlobal var2, Expression var3, Expression var4, CompareType var5);

    public abstract IPartialExpression getMember(ZenPosition var1, IEnvironmentGlobal var2, IPartialExpression var3, String var4);

    public abstract IPartialExpression getStaticMember(ZenPosition var1, IEnvironmentGlobal var2, String var3);

    public abstract Expression call(ZenPosition var1, IEnvironmentGlobal var2, Expression var3, Expression ... var4);

    public abstract Expression cast(ZenPosition var1, IEnvironmentGlobal var2, Expression var3, ZenType var4);

    public abstract IZenIterator makeIterator(int var1, IEnvironmentMethod var2);

    public abstract boolean canCastImplicit(ZenType var1, IEnvironmentGlobal var2);

    public abstract boolean canCastExplicit(ZenType var1, IEnvironmentGlobal var2);

    public abstract Class toJavaClass();

    public abstract Type toASMType();

    public abstract int getNumberType();

    public abstract String getSignature();

    public abstract boolean isPointer();

    public abstract void compileCast(ZenPosition var1, IEnvironmentMethod var2, ZenType var3);

    public abstract String getName();

    public abstract Expression defaultValue(ZenPosition var1);

    public boolean isLarge() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    protected Expression unaryExpansion(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        TypeExpansion expansion = environment.getExpansion(this.getName());
        if (expansion != null) {
            return expansion.unary(position, environment, value, operator);
        }
        return null;
    }

    protected Expression binaryExpansion(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        TypeExpansion expansion = environment.getExpansion(this.getName());
        if (expansion != null) {
            return expansion.binary(position, environment, left, right, operator);
        }
        return null;
    }

    protected Expression trinaryExpansion(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        TypeExpansion expansion = environment.getExpansion(this.getName());
        if (expansion != null) {
            return expansion.ternary(position, environment, first, second, third, operator);
        }
        return null;
    }

    protected IPartialExpression memberExpansion(ZenPosition position, IEnvironmentGlobal environment, Expression value, String member) {
        TypeExpansion expansion = environment.getExpansion(this.getName());
        if (expansion != null) {
            return expansion.instanceMember(position, environment, value, member);
        }
        return null;
    }

    protected IPartialExpression staticMemberExpansion(ZenPosition position, IEnvironmentGlobal environment, String member) {
        TypeExpansion expansion = environment.getExpansion(this.getName());
        if (expansion != null) {
            return expansion.staticMember(position, environment, member);
        }
        return null;
    }

    protected Expression castExpansion(ZenPosition position, IEnvironmentGlobal environment, Expression value, ZenType toType) {
        ZenExpandCaster caster;
        TypeExpansion expansion = environment.getExpansion(this.getName());
        if (expansion != null && (caster = expansion.getCaster(toType, environment)) != null) {
            return caster.cast(position, environment, value);
        }
        return null;
    }

    protected boolean canCastExpansion(IEnvironmentGlobal environment, ZenType toType) {
        ZenExpandCaster caster;
        String name = this.getName();
        TypeExpansion expansion = environment.getExpansion(name);
        return expansion != null && (caster = expansion.getCaster(toType, environment)) != null;
    }

    protected boolean compileCastExpansion(ZenPosition position, IEnvironmentMethod environment, ZenType toType) {
        ZenExpandCaster caster;
        TypeExpansion expansion = environment.getExpansion(this.getName());
        if (expansion != null && (caster = expansion.getCaster(toType, environment)) != null) {
            caster.compile(environment);
            return true;
        }
        return false;
    }
}

