/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import org.objectweb.asm.Type;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionAs;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ZenTypeByteObject
extends ZenType {
    public static final ZenTypeByteObject INSTANCE = new ZenTypeByteObject();

    private ZenTypeByteObject() {
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        return BYTE.unary(position, environment, value.cast(position, environment, BYTE), operator);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        return BYTE.binary(position, environment, left.cast(position, environment, BYTE), right, operator);
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        return BYTE.trinary(position, environment, first.cast(position, environment, BYTE), second, third, operator);
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        return BYTE.compare(position, environment, left.cast(position, environment, BYTE), right, type);
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        return BYTE.getMember(position, environment, value.eval(environment).cast(position, environment, BYTE), name);
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return BYTE.getStaticMember(position, environment, name);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        return BYTE.call(position, environment, receiver.cast(position, environment, BYTE), arguments);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        return BYTE.makeIterator(numValues, methodOutput);
    }

    @Override
    public boolean canCastImplicit(ZenType type, IEnvironmentGlobal environment) {
        return BYTE.canCastImplicit(type, environment);
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, Expression value, ZenType type) {
        if (type.getNumberType() > 0 || type == STRING) {
            return new ExpressionAs(position, value, type);
        }
        if (this.canCastExpansion(environment, type)) {
            return this.castExpansion(position, environment, value, type);
        }
        return new ExpressionAs(position, value, type);
    }

    @Override
    public boolean canCastExplicit(ZenType type, IEnvironmentGlobal environment) {
        return BYTE.canCastExplicit(type, environment);
    }

    @Override
    public Class toJavaClass() {
        return Byte.class;
    }

    @Override
    public Type toASMType() {
        return Type.getType(Byte.class);
    }

    @Override
    public int getNumberType() {
        return 1;
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(Byte.class);
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public void compileCast(ZenPosition position, IEnvironmentMethod environment, ZenType type) {
        if (type != this) {
            if (type == BYTE) {
                environment.getOutput().invokeVirtual(Byte.class, "byteValue", Byte.TYPE, new Class[0]);
            } else if (type == STRING) {
                environment.getOutput().invokeVirtual(Byte.class, "toString", String.class, new Class[0]);
            } else {
                environment.getOutput().invokeVirtual(Byte.class, "byteValue", Byte.TYPE, new Class[0]);
                BYTE.compileCast(position, environment, type);
            }
        }
    }

    @Override
    public String getName() {
        return "byte";
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }
}

