/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import stanhebben.zenscript.ZenRuntimeException;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.IterableList;
import stanhebben.zenscript.annotations.IterableMap;
import stanhebben.zenscript.annotations.IterableSimple;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMemberGetter;
import stanhebben.zenscript.annotations.ZenMemberSetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;
import stanhebben.zenscript.annotations.ZenSetter;
import stanhebben.zenscript.compiler.EnvironmentMethod;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionArithmeticUnary;
import stanhebben.zenscript.expression.ExpressionAs;
import stanhebben.zenscript.expression.ExpressionCompareGeneric;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.ZenTypeAssociative;
import stanhebben.zenscript.type.ZenTypeInt;
import stanhebben.zenscript.type.iterator.IteratorIterable;
import stanhebben.zenscript.type.iterator.IteratorList;
import stanhebben.zenscript.type.iterator.IteratorMap;
import stanhebben.zenscript.type.iterator.IteratorMapKeys;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.type.natives.ZenNativeCaster;
import stanhebben.zenscript.type.natives.ZenNativeMember;
import stanhebben.zenscript.type.natives.ZenNativeOperator;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;
import stanhebben.zenscript.value.IAny;

public class ZenTypeNative
extends ZenType {
    private static final int ITERATOR_NONE = 0;
    private static final int ITERATOR_ITERABLE = 1;
    private static final int ITERATOR_LIST = 2;
    private static final int ITERATOR_MAP = 3;
    private final Class cls;
    private final List<ZenTypeNative> implementing;
    private final Map<String, ZenNativeMember> members;
    private final Map<String, ZenNativeMember> staticMembers;
    private final List<ZenNativeCaster> casters;
    private final List<ZenNativeOperator> trinaryOperators;
    private final List<ZenNativeOperator> binaryOperators;
    private final List<ZenNativeOperator> unaryOperators;
    private int iteratorType;
    private String classPkg;
    private String className;
    private Annotation iteratorAnnotation;
    private ZenType iteratorKeyType;
    private ZenType iteratorValueType;

    public ZenTypeNative(Class cls) {
        this.cls = cls;
        this.members = new HashMap<String, ZenNativeMember>();
        this.staticMembers = new HashMap<String, ZenNativeMember>();
        this.casters = new ArrayList<ZenNativeCaster>();
        this.trinaryOperators = new ArrayList<ZenNativeOperator>();
        this.binaryOperators = new ArrayList<ZenNativeOperator>();
        this.unaryOperators = new ArrayList<ZenNativeOperator>();
        this.implementing = new ArrayList<ZenTypeNative>();
    }

    public void complete(ITypeRegistry types) {
        int iterator = 0;
        Annotation _iteratorAnnotation = null;
        String _classPkg = this.cls.getPackage().getName().replace('/', '.');
        String _className = this.cls.getSimpleName();
        boolean fully = false;
        LinkedList<ZenTypeNative> todo = new LinkedList<ZenTypeNative>();
        todo.add(this);
        this.addSubtypes(todo, types);
        Annotation[] clsAnnotations = this.cls.getAnnotations();
        for (Annotation annotation : clsAnnotations) {
            if (annotation instanceof ZenClass) {
                String value = ((ZenClass)annotation).value();
                int dot = value.lastIndexOf(46);
                if (dot < 0) {
                    _classPkg = null;
                    _className = value;
                } else {
                    _classPkg = value.substring(0, dot);
                    _className = value.substring(dot + 1);
                }
            }
            if (annotation instanceof IterableSimple) {
                iterator = 1;
                _iteratorAnnotation = annotation;
                if (!Iterable.class.isAssignableFrom(this.cls)) {
                    // empty if block
                }
            }
            if (annotation instanceof IterableList) {
                iterator = 2;
                _iteratorAnnotation = annotation;
                if (!List.class.isAssignableFrom(this.cls)) {
                    // empty if block
                }
            }
            if (!(annotation instanceof IterableMap)) continue;
            iterator = 3;
            _iteratorAnnotation = annotation;
            if (Map.class.isAssignableFrom(this.cls)) continue;
        }
        for (Method method : this.cls.getMethods()) {
            boolean isMethod = fully;
            String methodName = method.getName();
            for (Annotation annotation : method.getAnnotations()) {
                String name;
                if (annotation instanceof ZenCaster) {
                    Class<?> output = method.getReturnType();
                    this.casters.add(new ZenNativeCaster(this.cls, output, method.getName()));
                    isMethod = false;
                    continue;
                }
                if (annotation instanceof ZenGetter) {
                    ZenGetter getterAnnotation = (ZenGetter)annotation;
                    String string = name = getterAnnotation.value().length() == 0 ? method.getName() : getterAnnotation.value();
                    if (!this.members.containsKey(name)) {
                        this.members.put(name, new ZenNativeMember());
                    }
                    this.members.get(name).setGetter(new JavaMethod(this.cls, method, types));
                    isMethod = false;
                    continue;
                }
                if (annotation instanceof ZenSetter) {
                    ZenSetter setterAnnotation = (ZenSetter)annotation;
                    String string = name = setterAnnotation.value().length() == 0 ? method.getName() : setterAnnotation.value();
                    if (!this.members.containsKey(name)) {
                        this.members.put(name, new ZenNativeMember());
                    }
                    this.members.get(name).setSetter(new JavaMethod(this.cls, method, types));
                    isMethod = false;
                    continue;
                }
                if (annotation instanceof ZenMemberGetter) {
                    this.binaryOperators.add(new ZenNativeOperator(OperatorType.MEMBERGETTER, new JavaMethod(this.cls, method, types)));
                    continue;
                }
                if (annotation instanceof ZenMemberSetter) {
                    this.trinaryOperators.add(new ZenNativeOperator(OperatorType.MEMBERSETTER, new JavaMethod(this.cls, method, types)));
                    continue;
                }
                if (annotation instanceof ZenOperator) {
                    ZenOperator operatorAnnotation = (ZenOperator)annotation;
                    switch (operatorAnnotation.value()) {
                        case NEG: 
                        case NOT: {
                            if (method.getParameterTypes().length != 0) break;
                            this.unaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(this.cls, method, types)));
                            break;
                        }
                        case ADD: 
                        case SUB: 
                        case CAT: 
                        case MUL: 
                        case DIV: 
                        case MOD: 
                        case AND: 
                        case OR: 
                        case XOR: 
                        case INDEXGET: 
                        case RANGE: 
                        case CONTAINS: 
                        case COMPARE: {
                            if (method.getParameterTypes().length != 1) break;
                            this.binaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(this.cls, method, types)));
                            break;
                        }
                        case INDEXSET: {
                            if (method.getParameterTypes().length != 2) break;
                            this.trinaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(this.cls, method, types)));
                        }
                    }
                    isMethod = false;
                    continue;
                }
                if (!(annotation instanceof ZenMethod)) continue;
                isMethod = true;
                ZenMethod methodAnnotation = (ZenMethod)annotation;
                if (methodAnnotation.value().length() <= 0) continue;
                methodName = methodAnnotation.value();
            }
            if (!isMethod) continue;
            if ((method.getModifiers() & 8) > 0) {
                if (!this.staticMembers.containsKey(methodName)) {
                    this.staticMembers.put(methodName, new ZenNativeMember());
                }
                this.staticMembers.get(methodName).addMethod(new JavaMethod(this.cls, method, types));
                continue;
            }
            if (!this.members.containsKey(methodName)) {
                this.members.put(methodName, new ZenNativeMember());
            }
            this.members.get(methodName).addMethod(new JavaMethod(this.cls, method, types));
        }
        this.iteratorType = iterator;
        this.iteratorAnnotation = _iteratorAnnotation;
        this.classPkg = _classPkg;
        this.className = _className;
    }

    public Class getNativeClass() {
        return this.cls;
    }

    public void complete(IEnvironmentGlobal environment) {
        Annotation annotation;
        if (this.iteratorAnnotation instanceof IterableSimple) {
            annotation = (IterableSimple)this.iteratorAnnotation;
            this.iteratorValueType = ZenType.parse(annotation.value(), environment);
        }
        if (this.iteratorAnnotation instanceof IterableList) {
            annotation = (IterableList)this.iteratorAnnotation;
            this.iteratorKeyType = ZenTypeInt.INSTANCE;
            this.iteratorValueType = ZenType.parse(annotation.value(), environment);
        }
        if (this.iteratorAnnotation instanceof IterableMap) {
            annotation = (IterableMap)this.iteratorAnnotation;
            this.iteratorKeyType = ZenType.parse(annotation.key(), environment);
            this.iteratorValueType = ZenType.parse(annotation.value(), environment);
        }
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        ZenNativeMember member = this.members.get(name);
        if (member == null) {
            for (ZenTypeNative type : this.implementing) {
                if (!type.members.containsKey(name)) continue;
                member = type.members.get(name);
                break;
            }
        }
        if (member == null) {
            Expression evalue = value.eval(environment);
            IPartialExpression member2 = this.memberExpansion(position, environment, evalue, name);
            if (member2 == null) {
                ZenTypeNative type;
                Iterator<ZenTypeNative> iterator = this.implementing.iterator();
                while (iterator.hasNext() && (member2 = (type = iterator.next()).memberExpansion(position, environment, evalue, name)) == null) {
                }
            }
            if (member2 == null) {
                if (this.hasBinary(STRING, OperatorType.MEMBERGETTER)) {
                    return this.binary(position, environment, value.eval(environment), new ExpressionString(position, name), OperatorType.MEMBERGETTER);
                }
                environment.error(position, "No such member in " + this.getName() + ": " + name);
                return new ExpressionInvalid(position);
            }
            return member2;
        }
        return member.instance(position, environment, value);
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        ZenNativeMember member = this.staticMembers.get(name);
        if (member == null) {
            for (ZenTypeNative type : this.implementing) {
                if (!type.staticMembers.containsKey(name)) continue;
                member = type.staticMembers.get(name);
                break;
            }
        }
        if (member == null) {
            IPartialExpression member2 = this.staticMemberExpansion(position, environment, name);
            if (member2 == null) {
                ZenTypeNative type;
                Iterator<ZenTypeNative> iterator = this.implementing.iterator();
                while (iterator.hasNext() && (member2 = (type = iterator.next()).staticMemberExpansion(position, environment, name)) == null) {
                }
            }
            if (member2 == null) {
                environment.error(position, "No such static member in " + this.getName() + ": " + name);
                return new ExpressionInvalid(position);
            }
            return member2;
        }
        return member.instance(position, environment);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        switch (this.iteratorType) {
            case 0: {
                break;
            }
            case 1: {
                if (numValues == 1) {
                    return new IteratorIterable(methodOutput.getOutput(), this.iteratorValueType);
                }
                if (numValues != 2) break;
                return new IteratorList(methodOutput.getOutput(), this.iteratorValueType);
            }
            case 3: {
                if (numValues == 1) {
                    return new IteratorMapKeys(methodOutput.getOutput(), new ZenTypeAssociative(this.iteratorValueType, this.iteratorKeyType));
                }
                if (numValues != 2) break;
                return new IteratorMap(methodOutput.getOutput(), new ZenTypeAssociative(this.iteratorValueType, this.iteratorKeyType));
            }
            case 2: {
                if (numValues == 1) {
                    return new IteratorIterable(methodOutput.getOutput(), this.iteratorValueType);
                }
                if (numValues != 2) break;
                return new IteratorList(methodOutput.getOutput(), this.iteratorValueType);
            }
        }
        return null;
    }

    @Override
    public boolean canCastImplicit(ZenType type, IEnvironmentGlobal environment) {
        return type == this || ZenTypeNative.canCastImplicit(this.cls, type) || this.canCastExpansion(environment, type);
    }

    @Override
    public boolean canCastExplicit(ZenType type, IEnvironmentGlobal environment) {
        return type == this || ZenTypeNative.canCastImplicit(this.cls, type) || ZenTypeNative.canCastImplicit(type, this.cls) || this.canCastExpansion(environment, type);
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, Expression value, ZenType type) {
        if (type == this || ZenTypeNative.canCastImplicit(this.cls, type)) {
            return value;
        }
        if (this.canCastExpansion(environment, type)) {
            return this.castExpansion(position, environment, value, type);
        }
        return new ExpressionAs(position, value, type);
    }

    @Override
    public Class toJavaClass() {
        return this.cls;
    }

    @Override
    public Type toASMType() {
        return Type.getType((Class)this.cls);
    }

    @Override
    public int getNumberType() {
        return 0;
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(this.cls);
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    private static boolean canCastImplicit(Class cls, ZenType type) {
        if (ZenTypeNative.isEqual(cls, type)) {
            return true;
        }
        if (type == BOOL) {
            return true;
        }
        if (cls.getSuperclass() != null && ZenTypeNative.canCastImplicit(cls.getSuperclass(), type)) {
            return true;
        }
        for (Class<?> iface : cls.getInterfaces()) {
            if (!ZenTypeNative.canCastImplicit(iface, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean canCastImplicit(ZenType type, Class cls) {
        if (ZenTypeNative.isEqual(cls, type)) {
            return true;
        }
        if (type == BOOL) {
            return true;
        }
        if (type instanceof ZenTypeNative) {
            Class clsFrom = ((ZenTypeNative)type).cls;
            return cls.isAssignableFrom(clsFrom);
        }
        return false;
    }

    private static boolean isEqual(Class cls, ZenType type) {
        String signature = ZenTypeNative.getSignature(cls);
        return type.getSignature().equals(signature);
    }

    private static String getSignature(Class cls) {
        String signature = ZenTypeUtil.signature(cls);
        if (Number.class.isAssignableFrom(cls)) {
            if (cls == Byte.class) {
                signature = "B";
            } else if (cls == Short.class) {
                signature = "S";
            } else if (cls == Integer.class) {
                signature = "I";
            } else if (cls == Long.class) {
                signature = "J";
            } else if (cls == Float.class) {
                signature = "F";
            } else if (cls == Double.class) {
                signature = "D";
            }
        }
        return signature;
    }

    @Override
    public void compileCast(ZenPosition position, IEnvironmentMethod environment, ZenType toType) {
        Class toCls;
        if (toType == ZenTypeAny.INSTANCE) {
            String anyClassName = this.cls.getName() + "__Any";
            String anySignature = ZenTypeUtil.signature(IAny.class);
            String toSignature = "L" + anyClassName + "";
            if (!environment.containsClass(anyClassName)) {
                environment.putClass(anyClassName, new byte[0]);
                ClassWriter newClass = new ClassWriter(2);
                newClass.visit(50, 1, anyClassName, "L" + anyClassName + ";", ZenTypeUtil.signature(Object.class), new String[]{anySignature});
                newClass.visitField(2, "value", null, this.className, null);
                MethodOutput valueOfMethod = new MethodOutput((ClassVisitor)newClass, 9, "valueOf", "(" + this.getSignature() + ")L" + anyClassName + ";", null, null);
                valueOfMethod.start();
                valueOfMethod.newObject(anyClassName);
                valueOfMethod.loadObject(0);
                valueOfMethod.construct(anyClassName, this.getSignature());
                valueOfMethod.returnObject();
                valueOfMethod.end();
                MethodOutput constructorMethod = new MethodOutput((ClassVisitor)newClass, 1, "<init>", "(" + this.getSignature() + ")V", null, null);
                constructorMethod.start();
                constructorMethod.loadObject(1);
                constructorMethod.loadObject(0);
                constructorMethod.putField(toSignature, "value", null);
                constructorMethod.end();
                MethodOutput methodNot = new MethodOutput((ClassVisitor)newClass, 1, "not", "()" + anySignature, null, null);
                methodNot.start();
                this.compileAnyUnary(anySignature, OperatorType.NOT, new EnvironmentMethod(methodNot, environment));
                methodNot.end();
                MethodOutput methodNeg = new MethodOutput((ClassVisitor)newClass, 1, "neg", "()" + anySignature, null, null);
                methodNeg.start();
                this.compileAnyUnary(anySignature, OperatorType.NEG, new EnvironmentMethod(methodNeg, environment));
                methodNeg.end();
                MethodOutput methodAdd = new MethodOutput((ClassVisitor)newClass, 1, "add", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodAdd.start();
                this.compileAnyBinary(anySignature, OperatorType.ADD, new EnvironmentMethod(methodAdd, environment));
                methodAdd.end();
                MethodOutput methodSub = new MethodOutput((ClassVisitor)newClass, 1, "sub", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodSub.start();
                this.compileAnyBinary(anySignature, OperatorType.SUB, new EnvironmentMethod(methodSub, environment));
                methodSub.end();
                MethodOutput methodCat = new MethodOutput((ClassVisitor)newClass, 1, "cat", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodCat.start();
                this.compileAnyBinary(anySignature, OperatorType.CAT, new EnvironmentMethod(methodCat, environment));
                methodCat.end();
                MethodOutput methodMul = new MethodOutput((ClassVisitor)newClass, 1, "mul", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodMul.start();
                this.compileAnyBinary(anySignature, OperatorType.ADD, new EnvironmentMethod(methodMul, environment));
                methodMul.end();
                MethodOutput methodDiv = new MethodOutput((ClassVisitor)newClass, 1, "div", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodDiv.start();
                this.compileAnyBinary(anySignature, OperatorType.DIV, new EnvironmentMethod(methodDiv, environment));
                methodDiv.end();
                MethodOutput methodMod = new MethodOutput((ClassVisitor)newClass, 1, "mod", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodMod.start();
                this.compileAnyBinary(anySignature, OperatorType.MOD, new EnvironmentMethod(methodMod, environment));
                methodMod.end();
                MethodOutput methodAnd = new MethodOutput((ClassVisitor)newClass, 1, "and", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodAnd.start();
                this.compileAnyBinary(anySignature, OperatorType.AND, new EnvironmentMethod(methodAnd, environment));
                methodAnd.end();
                MethodOutput methodOr = new MethodOutput((ClassVisitor)newClass, 1, "or", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodOr.start();
                this.compileAnyBinary(anySignature, OperatorType.OR, new EnvironmentMethod(methodOr, environment));
                methodOr.end();
                MethodOutput methodXor = new MethodOutput((ClassVisitor)newClass, 1, "xor", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodXor.start();
                this.compileAnyBinary(anySignature, OperatorType.XOR, new EnvironmentMethod(methodXor, environment));
                methodXor.end();
                MethodOutput methodRange = new MethodOutput((ClassVisitor)newClass, 1, "range", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodRange.start();
                this.compileAnyBinary(anySignature, OperatorType.RANGE, new EnvironmentMethod(methodRange, environment));
                methodRange.end();
                MethodOutput methodContains = new MethodOutput((ClassVisitor)newClass, 1, "contains", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodContains.start();
                this.compileAnyBinary(anySignature, OperatorType.CONTAINS, new EnvironmentMethod(methodContains, environment));
                methodContains.end();
                MethodOutput methodIndexSet = new MethodOutput((ClassVisitor)newClass, 1, "indexSet", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodIndexSet.start();
                this.compileAnyBinary(anySignature, OperatorType.INDEXSET, new EnvironmentMethod(methodIndexSet, environment));
                methodIndexSet.end();
                MethodOutput methodCompare = new MethodOutput((ClassVisitor)newClass, 1, "compareTo", "(" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodCompare.start();
                this.compileAnyBinary(anySignature, OperatorType.COMPARE, new EnvironmentMethod(methodCompare, environment));
                methodCompare.end();
                MethodOutput methodMember = new MethodOutput((ClassVisitor)newClass, 1, "method", "(" + ZenTypeUtil.signature(String.class) + ")" + anySignature, null, null);
                methodMember.start();
                this.compileAnyMember(anySignature, new EnvironmentMethod(methodMember, environment));
                methodMember.end();
                MethodOutput methodCall = new MethodOutput((ClassVisitor)newClass, 1, "call", "([" + ZenTypeUtil.signature(IAny.class) + ")" + anySignature, null, null);
                methodCall.start();
                methodCall.aConstNull();
                methodCall.returnObject();
                methodCall.end();
                environment.putClass(anyClassName, newClass.toByteArray());
            }
            return;
        }
        if (toType instanceof ZenTypeNative && (toCls = toType.toJavaClass()).isAssignableFrom(this.cls)) {
            return;
        }
        MethodOutput output = environment.getOutput();
        if (toType == BOOL) {
            Label lbl = new Label();
            output.iConst0();
            output.ifNull(lbl);
            output.iConst1();
            output.label(lbl);
            return;
        }
        for (ZenNativeCaster caster : this.casters) {
            if (caster.getCasterClass() != toType.toJavaClass()) continue;
            caster.compile(output);
            return;
        }
        for (ZenNativeCaster caster : this.casters) {
            if (!toType.toJavaClass().isAssignableFrom(caster.getCasterClass())) continue;
            caster.compile(output);
            return;
        }
        if (this.compileCastExpansion(position, environment, toType)) {
            return;
        }
        output.checkCast(toType.toJavaClass());
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        for (ZenNativeOperator unaryOperator : this.unaryOperators) {
            if (unaryOperator.getOperator() != operator) continue;
            return unaryOperator.getMethod().callVirtual(position, environment, value, new Expression[0]);
        }
        environment.error(position, "operator not supported");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        for (ZenNativeOperator binaryOperator : this.binaryOperators) {
            if (binaryOperator.getOperator() != operator) continue;
            return binaryOperator.getMethod().callVirtual(position, environment, left, right);
        }
        environment.error(position, "operator not supported");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        for (ZenNativeOperator trinaryOperator : this.trinaryOperators) {
            if (trinaryOperator.getOperator() != operator) continue;
            return trinaryOperator.getMethod().callVirtual(position, environment, first, second, third);
        }
        environment.error(position, "operator not supported");
        return new ExpressionInvalid(position);
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        if (type == CompareType.EQ || type == CompareType.NE) {
            for (ZenNativeOperator binaryOperator : this.binaryOperators) {
                if (binaryOperator.getOperator() != OperatorType.EQUALS) continue;
                Expression result = binaryOperator.getMethod().callVirtual(position, environment, left, right);
                if (type == CompareType.EQ) {
                    return result;
                }
                return new ExpressionArithmeticUnary(position, OperatorType.NOT, result);
            }
        }
        return new ExpressionCompareGeneric(position, this.binary(position, environment, left, right, OperatorType.COMPARE), type);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean hasBinary(ZenType type, OperatorType operator) {
        for (ZenNativeOperator binaryOperator : this.binaryOperators) {
            if (binaryOperator.getOperator() != operator) continue;
            return true;
        }
        return false;
    }

    private void compileAnyUnary(String anySignature, OperatorType operator, IEnvironmentMethod environment) {
        ArrayList<ZenNativeOperator> operators = new ArrayList<ZenNativeOperator>();
        for (ZenNativeOperator unary : this.unaryOperators) {
            if (unary.getOperator() != operator) continue;
            operators.add(unary);
        }
        MethodOutput output = environment.getOutput();
        if (operators.isEmpty()) {
            output.newObject(ZenRuntimeException.class);
            output.dup();
            output.constant("Cannot " + (Object)((Object)operator) + " " + this.classPkg + '.' + this.className);
            output.construct(ZenRuntimeException.class, String.class);
            output.aThrow();
        } else {
            ZenNativeOperator unary;
            if (operators.size() > 1) {
                environment.error(null, "Multiple " + (Object)((Object)operator) + " operators for " + this.cls);
            }
            unary = (ZenNativeOperator)operators.get(0);
            output.loadObject(0);
            output.getField(anySignature, "value", ZenTypeUtil.signature(this.cls));
            output.invoke(unary.getMethod());
            environment.getType(unary.getClass()).compileCast(null, environment, ANY);
            output.returnObject();
        }
    }

    private void compileAnyBinary(String anySignature, OperatorType operator, IEnvironmentMethod environment) {
        ArrayList<ZenNativeOperator> operators = new ArrayList<ZenNativeOperator>();
        for (ZenNativeOperator binary : this.binaryOperators) {
            if (binary.getOperator() != operator) continue;
            operators.add(binary);
        }
        MethodOutput output = environment.getOutput();
        if (operators.isEmpty()) {
            output.newObject(ZenRuntimeException.class);
            output.dup();
            output.constant("Cannot " + (Object)((Object)operator) + " on " + this.classPkg + '.' + this.className);
            output.construct(ZenRuntimeException.class, String.class);
            output.aThrow();
        } else if (operators.size() == 1) {
            ZenNativeOperator binary;
            binary = (ZenNativeOperator)operators.get(0);
            output.loadObject(0);
            output.getField(anySignature, "value", ZenTypeUtil.signature(this.cls));
            output.loadObject(1);
            output.invoke(binary.getMethod());
            environment.getType(binary.getClass()).compileCast(null, environment, ANY);
            output.returnObject();
        } else {
            environment.error(null, "Multiple " + (Object)((Object)operator) + " operators for " + this.cls + " (which is not yet supported)");
        }
    }

    public void compileAnyMember(String anySignature, EnvironmentMethod environment) {
        MethodOutput output = environment.getOutput();
        output.aConstNull();
        output.returnObject();
    }

    @Override
    public String getName() {
        return this.classPkg + '.' + this.className;
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    private void addSubtypes(Queue<ZenTypeNative> todo, ITypeRegistry types) {
        while (!todo.isEmpty()) {
            ZenType type;
            ZenTypeNative current = todo.poll();
            if (current.cls.getSuperclass() != Object.class && (type = types.getType(current.cls.getSuperclass())) instanceof ZenTypeNative) {
                todo.offer((ZenTypeNative)type);
                this.implementing.add((ZenTypeNative)type);
            }
            for (Class<?> iface : current.cls.getInterfaces()) {
                ZenType type2 = types.getType(iface);
                if (!(type2 instanceof ZenTypeNative)) continue;
                todo.offer((ZenTypeNative)type2);
                this.implementing.add((ZenTypeNative)type2);
            }
        }
    }
}

