/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.natives;

import java.util.ArrayList;
import java.util.List;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.StringUtil;
import stanhebben.zenscript.util.ZenPosition;

public class ZenNativeMember {
    private JavaMethod getter;
    private JavaMethod setter;
    private final List<JavaMethod> methods = new ArrayList<JavaMethod>();

    public JavaMethod getGetter() {
        return this.getter;
    }

    public JavaMethod getSetter() {
        return this.setter;
    }

    public void setGetter(JavaMethod getter) {
        if (this.getter != null) {
            throw new RuntimeException("already has a getter");
        }
        this.getter = getter;
    }

    public void setSetter(JavaMethod setter) {
        if (this.setter != null) {
            throw new RuntimeException("already has a setter");
        }
        this.setter = setter;
    }

    public IPartialExpression instance(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value) {
        return new InstanceGetValue(position, value);
    }

    public IPartialExpression instance(ZenPosition position, IEnvironmentGlobal environment) {
        return new StaticGetValue(position);
    }

    public void addMethod(JavaMethod method) {
        this.methods.add(method);
    }

    private class StaticSymbol
    implements IZenSymbol {
        private StaticSymbol() {
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            return new StaticGetValue(position);
        }
    }

    private class StaticGetValue
    implements IPartialExpression {
        private final ZenPosition position;

        public StaticGetValue(ZenPosition position) {
            this.position = position;
        }

        @Override
        public Expression eval(IEnvironmentGlobal environment) {
            return ZenNativeMember.this.setter.callStatic(this.position, environment, new Expression[0]);
        }

        @Override
        public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
            return ZenNativeMember.this.setter.callStatic(position, environment, other);
        }

        @Override
        public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
            ZenType type = environment.getType(ZenNativeMember.this.getter.getMethod().getGenericReturnType());
            return type.getMember(position, environment, this, name);
        }

        @Override
        public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
            JavaMethod method = JavaMethod.select(true, ZenNativeMember.this.methods, environment, values);
            if (method == null) {
                environment.error(position, StringUtil.methodMatchingError(ZenNativeMember.this.methods, values));
                return new ExpressionInvalid(position);
            }
            return method.callStatic(position, environment, values);
        }

        @Override
        public IZenSymbol toSymbol() {
            return new StaticSymbol();
        }

        @Override
        public ZenType toType(IEnvironmentGlobal environment) {
            environment.error(this.position, "not a valid type");
            return ZenType.ANY;
        }
    }

    private class InstanceGetValue
    implements IPartialExpression {
        private final ZenPosition position;
        private final IPartialExpression value;

        public InstanceGetValue(ZenPosition position, IPartialExpression value) {
            this.position = position;
            this.value = value;
        }

        @Override
        public Expression eval(IEnvironmentGlobal environment) {
            return ZenNativeMember.this.getter.callVirtual(this.position, environment, this.value.eval(environment), new Expression[0]);
        }

        @Override
        public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
            return ZenNativeMember.this.setter.callVirtual(position, environment, this.value.eval(environment), other);
        }

        @Override
        public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
            ZenType type = environment.getType(ZenNativeMember.this.getter.getMethod().getGenericReturnType());
            return type.getMember(position, environment, this, name);
        }

        @Override
        public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
            JavaMethod method = JavaMethod.select(false, ZenNativeMember.this.methods, environment, values);
            if (method == null) {
                environment.error(position, StringUtil.methodMatchingError(ZenNativeMember.this.methods, values));
                return new ExpressionInvalid(position);
            }
            return method.callVirtual(position, environment, this.value.eval(environment), values);
        }

        @Override
        public IZenSymbol toSymbol() {
            return null;
        }

        @Override
        public ZenType toType(IEnvironmentGlobal environment) {
            environment.error(this.position, "not a valid type");
            return ZenType.ANY;
        }
    }
}

