/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.util;

import java.lang.reflect.Field;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class MethodOutput {
    private final LocalVariablesSorter visitor;

    public MethodOutput(ClassVisitor cls, int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = cls.visitMethod(access, name, descriptor, signature, exceptions);
        this.visitor = new LocalVariablesSorter(access, descriptor, methodVisitor);
    }

    public MethodOutput(LocalVariablesSorter visitor) {
        this.visitor = visitor;
    }

    public void start() {
        this.visitor.visitCode();
    }

    public void end() {
        this.visitor.visitMaxs(0, 0);
        this.visitor.visitEnd();
    }

    public void label(Label label) {
        this.visitor.visitLabel(label);
    }

    public int local(Type type) {
        return this.visitor.newLocal(type);
    }

    public int local(Class cls) {
        return this.visitor.newLocal(Type.getType((Class)cls));
    }

    public void iConst0() {
        this.visitor.visitInsn(3);
    }

    public void iConst1() {
        this.visitor.visitInsn(4);
    }

    public void biPush(byte value) {
        this.visitor.visitIntInsn(16, (int)value);
    }

    public void siPush(short value) {
        this.visitor.visitIntInsn(17, (int)value);
    }

    public void aConstNull() {
        this.visitor.visitInsn(1);
    }

    public void constant(Object value) {
        this.visitor.visitLdcInsn(value);
    }

    public void pop() {
        this.visitor.visitInsn(87);
    }

    public void pop(boolean large) {
        this.visitor.visitInsn(large ? 88 : 87);
    }

    public void dup() {
        this.visitor.visitInsn(89);
    }

    public void dup(boolean large) {
        this.visitor.visitInsn(large ? 92 : 89);
    }

    public void dup2() {
        this.visitor.visitInsn(92);
    }

    public void dupX1() {
        this.visitor.visitInsn(90);
    }

    public void dupX2() {
        this.visitor.visitInsn(91);
    }

    public void dup2X1() {
        this.visitor.visitInsn(93);
    }

    public void dup2X2() {
        this.visitor.visitInsn(94);
    }

    public void store(Type type, int local) {
        this.visitor.visitVarInsn(type.getOpcode(54), local);
    }

    public void load(Type type, int local) {
        this.visitor.visitVarInsn(type.getOpcode(21), local);
    }

    public void storeInt(int local) {
        this.visitor.visitVarInsn(54, local);
    }

    public void loadInt(int local) {
        this.visitor.visitVarInsn(21, local);
    }

    public void storeObject(int local) {
        this.visitor.visitVarInsn(58, local);
    }

    public void loadObject(int local) {
        this.visitor.visitVarInsn(25, local);
    }

    public void arrayLength() {
        this.visitor.visitInsn(190);
    }

    public void arrayLoad(Type type) {
        this.visitor.visitInsn(type.getOpcode(46));
    }

    public void arrayStore(Type type) {
        this.visitor.visitInsn(type.getOpcode(79));
    }

    public void newArray(Type componentType) {
        int sort = componentType.getSort();
        if (sort == 11) {
            throw new RuntimeException("Unsupported array type: " + componentType);
        }
        if (sort == 10 || sort == 9) {
            this.visitor.visitTypeInsn(189, componentType.getInternalName());
        } else {
            int type = 0;
            switch (sort) {
                case 1: {
                    type = 4;
                    break;
                }
                case 3: {
                    type = 8;
                    break;
                }
                case 4: {
                    type = 9;
                    break;
                }
                case 5: {
                    type = 10;
                    break;
                }
                case 7: {
                    type = 11;
                    break;
                }
                case 6: {
                    type = 6;
                    break;
                }
                case 8: {
                    type = 7;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported array type: " + componentType);
                }
            }
            this.visitor.visitIntInsn(188, type);
        }
    }

    public void newArray(Class componentType) {
        this.visitor.visitTypeInsn(188, ZenTypeUtil.internal(componentType));
    }

    public void checkCast(Class newClass) {
        this.visitor.visitTypeInsn(192, ZenTypeUtil.signature(newClass));
    }

    public void checkCast(String newClass) {
        this.visitor.visitTypeInsn(192, newClass.substring(1, newClass.length() - 1));
    }

    public void iNeg() {
        this.visitor.visitInsn(116);
    }

    public void iAdd() {
        this.visitor.visitInsn(96);
    }

    public void iSub() {
        this.visitor.visitInsn(100);
    }

    public void iMul() {
        this.visitor.visitInsn(104);
    }

    public void iDiv() {
        this.visitor.visitInsn(108);
    }

    public void iRem() {
        this.visitor.visitInsn(112);
    }

    public void iAnd() {
        this.visitor.visitInsn(126);
    }

    public void iOr() {
        this.visitor.visitInsn(128);
    }

    public void iXor() {
        this.visitor.visitInsn(130);
    }

    public void iNot() {
        this.visitor.visitInsn(2);
        this.visitor.visitInsn(130);
    }

    public void lNeg() {
        this.visitor.visitInsn(117);
    }

    public void lAdd() {
        this.visitor.visitInsn(97);
    }

    public void lSub() {
        this.visitor.visitInsn(101);
    }

    public void lMul() {
        this.visitor.visitInsn(105);
    }

    public void lDiv() {
        this.visitor.visitInsn(109);
    }

    public void lRem() {
        this.visitor.visitInsn(113);
    }

    public void lAnd() {
        this.visitor.visitInsn(127);
    }

    public void lOr() {
        this.visitor.visitInsn(129);
    }

    public void lXor() {
        this.visitor.visitInsn(131);
    }

    public void lNot() {
        this.constant(-1L);
        this.lXor();
    }

    public void fNeg() {
        this.visitor.visitInsn(118);
    }

    public void fAdd() {
        this.visitor.visitInsn(98);
    }

    public void fSub() {
        this.visitor.visitInsn(102);
    }

    public void fMul() {
        this.visitor.visitInsn(106);
    }

    public void fDiv() {
        this.visitor.visitInsn(110);
    }

    public void fRem() {
        this.visitor.visitInsn(114);
    }

    public void dNeg() {
        this.visitor.visitInsn(119);
    }

    public void dAdd() {
        this.visitor.visitInsn(99);
    }

    public void dSub() {
        this.visitor.visitInsn(103);
    }

    public void dMul() {
        this.visitor.visitInsn(107);
    }

    public void dDiv() {
        this.visitor.visitInsn(111);
    }

    public void dRem() {
        this.visitor.visitInsn(115);
    }

    public void iinc(int local) {
        this.visitor.visitIincInsn(local, 1);
    }

    public void iinc(int local, int increment) {
        this.visitor.visitIincInsn(local, increment);
    }

    public void i2b() {
        this.visitor.visitInsn(145);
    }

    public void i2s() {
        this.visitor.visitInsn(147);
    }

    public void i2l() {
        this.visitor.visitInsn(133);
    }

    public void i2f() {
        this.visitor.visitInsn(134);
    }

    public void i2d() {
        this.visitor.visitInsn(135);
    }

    public void l2i() {
        this.visitor.visitInsn(136);
    }

    public void l2f() {
        this.visitor.visitInsn(137);
    }

    public void l2d() {
        this.visitor.visitInsn(138);
    }

    public void f2i() {
        this.visitor.visitInsn(139);
    }

    public void f2l() {
        this.visitor.visitInsn(140);
    }

    public void f2d() {
        this.visitor.visitInsn(141);
    }

    public void d2i() {
        this.visitor.visitInsn(142);
    }

    public void d2l() {
        this.visitor.visitInsn(143);
    }

    public void d2f() {
        this.visitor.visitInsn(144);
    }

    public void lCmp() {
        this.visitor.visitInsn(148);
    }

    public void fCmp() {
        this.visitor.visitInsn(149);
    }

    public void dCmp() {
        this.visitor.visitInsn(151);
    }

    public void invokeStatic(String owner, String name, String descriptor) {
        this.visitor.visitMethodInsn(184, owner, name, descriptor);
    }

    public void invokeStatic(Class owner, String name, Class result, Class ... arguments) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append('(');
        for (Class argument : arguments) {
            descriptor.append(ZenTypeUtil.signature(argument));
        }
        descriptor.append(')');
        descriptor.append(result == null ? Character.valueOf('V') : ZenTypeUtil.signature(result));
        this.visitor.visitMethodInsn(184, ZenTypeUtil.internal(owner), name, descriptor.toString());
    }

    public void invokeStatic(JavaMethod method) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append('(');
        for (Class<?> argument : method.getMethod().getParameterTypes()) {
            descriptor.append(ZenTypeUtil.signature(argument));
        }
        descriptor.append(')');
        descriptor.append(ZenTypeUtil.signature(method.getMethod().getReturnType()));
        this.visitor.visitMethodInsn(184, ZenTypeUtil.internal(method.getOwner()), method.getMethod().getName(), descriptor.toString());
    }

    public void invokeSpecial(String owner, String name, String descriptor) {
        this.visitor.visitMethodInsn(183, owner, name, descriptor);
    }

    public void invoke(Class owner, String name, Class result, Class ... arguments) {
        if (owner.isInterface()) {
            this.invokeInterface(owner, name, result, arguments);
        } else {
            this.invokeVirtual(owner, name, result, arguments);
        }
    }

    public void invoke(JavaMethod method) {
        if (method.getOwner().isInterface()) {
            this.invokeInterface(method.getOwner(), method.getMethod().getName(), method.getMethod().getReturnType(), method.getMethod().getParameterTypes());
        } else {
            this.invokeVirtual(method.getOwner(), method.getMethod().getName(), method.getMethod().getReturnType(), method.getMethod().getParameterTypes());
        }
    }

    public void invokeVirtual(String owner, String name, String descriptor) {
        this.visitor.visitMethodInsn(182, owner, name, descriptor);
    }

    public void invokeVirtual(Class owner, String name, Class result, Class ... arguments) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append('(');
        for (Class argument : arguments) {
            descriptor.append(ZenTypeUtil.signature(argument));
        }
        descriptor.append(')');
        descriptor.append(result == null ? Character.valueOf('V') : ZenTypeUtil.signature(result));
        this.visitor.visitMethodInsn(182, ZenTypeUtil.internal(owner), name, descriptor.toString());
    }

    public void invokeInterface(String owner, String name, String descriptor) {
        this.visitor.visitMethodInsn(185, owner, name, descriptor);
    }

    public void invokeInterface(Class owner, String name, Class result, Class ... arguments) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append('(');
        for (Class argument : arguments) {
            descriptor.append(ZenTypeUtil.signature(argument));
        }
        descriptor.append(')');
        descriptor.append(result == null ? Character.valueOf('V') : ZenTypeUtil.signature(result));
        this.visitor.visitMethodInsn(185, ZenTypeUtil.internal(owner), name, descriptor.toString());
    }

    public void newObject(Class type) {
        this.visitor.visitTypeInsn(187, ZenTypeUtil.internal(type));
    }

    public void newObject(String type) {
        this.visitor.visitTypeInsn(187, type);
    }

    public void construct(Class type, Class ... arguments) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append('(');
        for (Class argument : arguments) {
            descriptor.append(ZenTypeUtil.signature(argument));
        }
        descriptor.append(")V");
        this.visitor.visitMethodInsn(183, ZenTypeUtil.internal(type), "<init>", descriptor.toString());
    }

    public void construct(String type, String ... arguments) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append('(');
        for (String argument : arguments) {
            descriptor.append(argument);
        }
        descriptor.append(")V");
        this.visitor.visitMethodInsn(183, type, "<init>", descriptor.toString());
    }

    public void goTo(Label lbl) {
        this.visitor.visitJumpInsn(167, lbl);
    }

    public void ifEQ(Label lbl) {
        this.visitor.visitJumpInsn(153, lbl);
    }

    public void ifNE(Label lbl) {
        this.visitor.visitJumpInsn(154, lbl);
    }

    public void ifLT(Label lbl) {
        this.visitor.visitJumpInsn(155, lbl);
    }

    public void ifGT(Label lbl) {
        this.visitor.visitJumpInsn(157, lbl);
    }

    public void ifGE(Label lbl) {
        this.visitor.visitJumpInsn(156, lbl);
    }

    public void ifLE(Label lbl) {
        this.visitor.visitJumpInsn(158, lbl);
    }

    public void ifICmpLE(Label lbl) {
        this.visitor.visitJumpInsn(164, lbl);
    }

    public void ifICmpGE(Label lbl) {
        this.visitor.visitJumpInsn(162, lbl);
    }

    public void ifICmpEQ(Label lbl) {
        this.visitor.visitJumpInsn(159, lbl);
    }

    public void ifICmpNE(Label lbl) {
        this.visitor.visitJumpInsn(160, lbl);
    }

    public void ifICmpGT(Label lbl) {
        this.visitor.visitJumpInsn(163, lbl);
    }

    public void ifICmpLT(Label lbl) {
        this.visitor.visitJumpInsn(161, lbl);
    }

    public void ifNull(Label lbl) {
        this.visitor.visitJumpInsn(198, lbl);
    }

    public void ifNonNull(Label lbl) {
        this.visitor.visitJumpInsn(199, lbl);
    }

    public void ret() {
        this.visitor.visitInsn(177);
    }

    public void returnType(Type type) {
        this.visitor.visitInsn(type.getOpcode(172));
    }

    public void returnInt() {
        this.visitor.visitInsn(172);
    }

    public void returnObject() {
        this.visitor.visitInsn(176);
    }

    public void getField(String owner, String name, String descriptor) {
        this.visitor.visitFieldInsn(180, owner, name, descriptor);
    }

    public void getField(Class owner, String name, Class descriptor) {
        this.visitor.visitFieldInsn(180, ZenTypeUtil.internal(owner), name, ZenTypeUtil.signature(descriptor));
    }

    public void putField(String owner, String name, String descriptor) {
        this.visitor.visitFieldInsn(181, owner, name, descriptor);
    }

    public void putField(Class owner, String name, Class descriptor) {
        this.visitor.visitFieldInsn(181, ZenTypeUtil.internal(owner), name, ZenTypeUtil.signature(descriptor));
    }

    public void getStaticField(Class owner, Field field) {
        this.visitor.visitFieldInsn(178, ZenTypeUtil.internal(owner), field.getName(), ZenTypeUtil.signature(field.getType()));
    }

    public void putStaticField(Class owner, Field field) {
        this.visitor.visitFieldInsn(179, ZenTypeUtil.internal(owner), field.getName(), ZenTypeUtil.signature(field.getType()));
    }

    public void aThrow() {
        this.visitor.visitInsn(191);
    }

    public void position(ZenPosition position) {
        Label label = new Label();
        this.visitor.visitLabel(label);
        this.visitor.visitLineNumber(position.getLine(), label);
    }
}

