/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.brackets;

import java.util.List;
import minetweaker.IBracketHandler;
import minetweaker.annotations.BracketHandler;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.mc1710.liquid.MCLiquidStack;
import minetweaker.runtime.GlobalRegistry;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.expression.ExpressionJavaCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler
public class LiquidBracketHandler
implements IBracketHandler {
    public static ILiquidStack getLiquid(String name) {
        Fluid fluid = FluidRegistry.getFluid((String)name);
        if (fluid != null) {
            return new MCLiquidStack(new FluidStack(fluid, 1));
        }
        return null;
    }

    @Override
    public IZenSymbol resolve(List<Token> tokens) {
        if (tokens.size() > 2 && tokens.get(0).getValue().equals("liquid") && tokens.get(1).getValue().equals(":")) {
            return this.find(tokens, 2, tokens.size());
        }
        return null;
    }

    private IZenSymbol find(List<Token> tokens, int startIndex, int endIndex) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        Fluid fluid = FluidRegistry.getFluid((String)valueBuilder.toString());
        if (fluid != null) {
            return new LiquidReferenceSymbol(valueBuilder.toString());
        }
        return null;
    }

    private class LiquidReferenceSymbol
    implements IZenSymbol {
        private final String name;

        public LiquidReferenceSymbol(String name) {
            this.name = name;
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            JavaMethod method = JavaMethod.get(GlobalRegistry.getTypeRegistry(), LiquidBracketHandler.class, "getLiquid", String.class);
            return new ExpressionJavaCallStatic(position, method, new ExpressionString(position, this.name));
        }
    }
}

