/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeAny;
import stanhebben.zenscript.type.ZenTypeArrayBasic;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionArray
extends Expression {
    private final Expression[] contents;
    private final ZenTypeArrayBasic type;

    public ExpressionArray(ZenPosition position, Expression ... contents) {
        super(position);
        this.contents = contents;
        this.type = new ZenTypeArrayBasic(ZenTypeAny.INSTANCE);
    }

    public ExpressionArray(ZenPosition position, Expression[] contents, ZenTypeArrayBasic type) {
        super(position);
        this.contents = contents;
        this.type = type;
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, ZenType type) {
        if (type instanceof ZenTypeArrayBasic) {
            ZenTypeArrayBasic arrayType = (ZenTypeArrayBasic)type;
            Expression[] newContents = new Expression[this.contents.length];
            for (int i = 0; i < this.contents.length; ++i) {
                newContents[i] = this.contents[i].cast(position, environment, arrayType.getBaseType());
            }
            return new ExpressionArray(this.getPosition(), newContents, arrayType);
        }
        if (this.type.canCastImplicit(type, environment)) {
            return this.type.cast(position, environment, this, type);
        }
        environment.error(position, "cannot cast " + this.type + " to " + type);
        return new ExpressionInvalid(position, type);
    }

    @Override
    public ZenType getType() {
        return this.type;
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        Type baseType = this.type.getBaseType().toASMType();
        MethodOutput output = environment.getOutput();
        output.constant(this.contents.length);
        output.newArray(baseType);
        for (int i = 0; i < this.contents.length; ++i) {
            output.dup();
            output.constant(i);
            this.contents[i].compile(result, environment);
            output.arrayStore(baseType);
        }
    }
}

