/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import org.objectweb.asm.Type;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionAs;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;

public class ZenTypeLongObject
extends ZenType {
    public static final ZenTypeLongObject INSTANCE = new ZenTypeLongObject();

    private ZenTypeLongObject() {
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        return LONG.unary(position, environment, value.cast(position, environment, LONG), operator);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        return LONG.binary(position, environment, left.cast(position, environment, LONG), right, operator);
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        return LONG.trinary(position, environment, first.cast(position, environment, LONG), second, third, operator);
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        return LONG.compare(position, environment, left.cast(position, environment, LONG), right, type);
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        return LONG.getMember(position, environment, value.eval(environment).cast(position, environment, LONG), name);
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        return LONG.getStaticMember(position, environment, name);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        return LONG.call(position, environment, receiver.cast(position, environment, LONG), arguments);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        return LONG.makeIterator(numValues, methodOutput);
    }

    @Override
    public boolean canCastImplicit(ZenType type, IEnvironmentGlobal environment) {
        return LONG.canCastImplicit(type, environment);
    }

    @Override
    public boolean canCastExplicit(ZenType type, IEnvironmentGlobal environment) {
        return LONG.canCastExplicit(type, environment);
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, Expression value, ZenType type) {
        if (type.getNumberType() > 0 || type == STRING) {
            return new ExpressionAs(position, value, type);
        }
        if (this.canCastExpansion(environment, type)) {
            return this.castExpansion(position, environment, value, type);
        }
        return new ExpressionAs(position, value, type);
    }

    @Override
    public Class toJavaClass() {
        return Long.class;
    }

    @Override
    public Type toASMType() {
        return Type.getType(Long.class);
    }

    @Override
    public int getNumberType() {
        return 4;
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(Long.class);
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public void compileCast(ZenPosition position, IEnvironmentMethod environment, ZenType type) {
        if (type != this) {
            if (type == LONG) {
                environment.getOutput().invokeVirtual(Long.class, "longValue", Long.TYPE, new Class[0]);
            } else if (type == STRING) {
                environment.getOutput().invokeVirtual(Long.class, "toString", String.class, new Class[0]);
            } else {
                environment.getOutput().invokeVirtual(Long.class, "longValue", Long.TYPE, new Class[0]);
                LONG.compileCast(position, environment, type);
            }
        }
    }

    @Override
    public String getName() {
        return "long";
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }
}

