/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.item;

import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="minetweaker.item.IIngredient")
public class IngredientTransform {
    @ZenMethod
    public static IIngredient reuse(IIngredient ingredient) {
        return ingredient.transform(new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                return item.withAmount(item.getAmount() + 1);
            }
        });
    }

    @ZenMethod
    public static IIngredient transformDamage(IIngredient ingredient) {
        return ingredient.transform(new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                int newDamage = item.getDamage() + 1;
                if (newDamage >= item.getMaxDamage()) {
                    return item.withAmount(item.getAmount()).withDamage(0);
                }
                return item.withAmount(item.getAmount() + 1).withDamage(newDamage);
            }
        });
    }

    @ZenMethod
    public static IIngredient transformDamage(IIngredient ingredient, final int damage) {
        return ingredient.transform(new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                int newDamage = item.getDamage() + damage;
                if (newDamage >= item.getMaxDamage()) {
                    return item.withAmount(item.getAmount()).withDamage(0);
                }
                return item.withAmount(item.getAmount() + 1).withDamage(newDamage);
            }
        });
    }

    @ZenMethod
    public static IIngredient transformReplace(IIngredient ingredient, final IItemStack withItem) {
        return ingredient.transform(new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                return withItem.withAmount(withItem.getAmount() + 1);
            }
        });
    }

    @ZenMethod
    public static IIngredient transformConsume(IIngredient ingredient, final int amount) {
        return ingredient.transform(new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                return item.withAmount(Math.max(item.getAmount() - amount, 0) + 1);
            }
        });
    }
}

