/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.api.item;

import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IItemTransformer;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="minetweaker.item.Transform")
public class Transform {
    @ZenMethod
    public static IItemTransformer reuse() {
        return new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                return item.withAmount(item.getAmount() + 1);
            }
        };
    }

    @ZenMethod
    public static IItemTransformer damage() {
        return new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                int newDamage = item.getDamage() + 1;
                if (newDamage >= item.getMaxDamage()) {
                    return item.withAmount(item.getAmount()).withDamage(0);
                }
                return item.withAmount(item.getAmount() + 1).withDamage(newDamage);
            }
        };
    }

    @ZenMethod
    public static IItemTransformer damage(final int damage) {
        return new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                int newDamage = item.getDamage() + damage;
                if (newDamage >= item.getMaxDamage()) {
                    return item.withAmount(item.getAmount() - 1).withDamage(newDamage - item.getMaxDamage());
                }
                return item.withDamage(newDamage);
            }
        };
    }

    @ZenMethod
    public static IItemTransformer replaceWith(final IItemStack withItem) {
        return new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                return withItem.withAmount(withItem.getAmount() + 1);
            }
        };
    }

    @ZenMethod
    public static IItemTransformer consume(final int amount) {
        return new IItemTransformer(){

            @Override
            public IItemStack transform(IItemStack item) {
                return item.withAmount(Math.max(item.getAmount() - amount, 0) + 1);
            }
        };
    }
}

