/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1710.brackets;

import java.util.List;
import minetweaker.IBracketHandler;
import minetweaker.annotations.BracketHandler;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.mc1710.oredict.MCOreDictEntry;
import minetweaker.runtime.GlobalRegistry;
import stanhebben.zenscript.expression.ExpressionJavaCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler
public class OreBracketHandler
implements IBracketHandler {
    public static IOreDictEntry getOre(String name) {
        return new MCOreDictEntry(name);
    }

    @Override
    public IZenSymbol resolve(List<Token> tokens) {
        if (tokens.size() > 2 && tokens.get(0).getValue().equals("ore") && tokens.get(1).getValue().equals(":")) {
            return this.find(tokens, 2, tokens.size());
        }
        return null;
    }

    private IZenSymbol find(List<Token> tokens, int startIndex, int endIndex) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        return new OreReferenceSymbol(valueBuilder.toString());
    }

    private class OreReferenceSymbol
    implements IZenSymbol {
        private final String name;

        public OreReferenceSymbol(String name) {
            this.name = name;
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            JavaMethod method = JavaMethod.get(GlobalRegistry.getTypeRegistry(), OreBracketHandler.class, "getOre", String.class);
            return new ExpressionJavaCallStatic(position, method, new ExpressionString(position, this.name));
        }
    }
}

