/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2;

import ic2.api.item.IC2Items;
import java.util.List;
import minetweaker.IBracketHandler;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.BracketHandler;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.expression.ExpressionInt;
import stanhebben.zenscript.expression.ExpressionJavaCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler
@ModOnly(value={"IC2"})
public class IC2BracketHandler
implements IBracketHandler {
    private final JavaMethod method = MineTweakerAPI.getJavaMethod(IC2BracketHandler.class, "getItem", String.class, Integer.TYPE);

    public static IItemStack getItem(String name, int meta) {
        ItemStack stack = IC2Items.getItem((String)name);
        stack.func_77964_b(meta);
        return MineTweakerMC.getIItemStack(stack);
    }

    @Override
    public IZenSymbol resolve(List<Token> tokens) {
        if (tokens.size() >= 5) {
            if (tokens.get(0).getValue().equals("ic2") && tokens.get(1).getValue().equals("-") && tokens.get(2).getValue().equals("item") && tokens.get(3).getValue().equals(":")) {
                ItemStack item;
                String name = tokens.get(4).getValue();
                int meta = 0;
                if (tokens.size() > 6 && tokens.get(5).getValue().equals(":")) {
                    if (tokens.get(6).getType() == 2) {
                        meta = Integer.parseInt(tokens.get(6).getValue());
                    } else if (tokens.get(6).getValue().equals("*")) {
                        meta = Short.MAX_VALUE;
                    } else {
                        MineTweakerAPI.logError("Not a valid meta value: " + tokens.get(6).getValue());
                    }
                }
                if ((item = IC2Items.getItem((String)name)) == null) {
                    MineTweakerAPI.logError("Not a valid IC2 item: " + name);
                    return null;
                }
                return new ItemReferenceSymbol(name, meta);
            }
            return null;
        }
        return null;
    }

    private class ItemReferenceSymbol
    implements IZenSymbol {
        private final String name;
        private final int meta;

        public ItemReferenceSymbol(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            return new ExpressionJavaCallStatic(position, IC2BracketHandler.this.method, new ExpressionString(position, this.name), new ExpressionInt(position, this.meta, ZenType.INT));
        }
    }
}

