/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenMethodStatic;
import stanhebben.zenscript.annotations.ZenOperator;
import stanhebben.zenscript.annotations.ZenSetter;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ITypeRegistry;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.expand.ZenExpandCaster;
import stanhebben.zenscript.type.expand.ZenExpandMember;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.type.natives.ZenNativeOperator;
import stanhebben.zenscript.util.ZenPosition;

public class TypeExpansion {
    private final String type;
    private final Map<String, ZenExpandMember> members;
    private final Map<String, ZenExpandMember> staticMembers;
    private final List<ZenExpandCaster> casters;
    private final List<ZenNativeOperator> trinaryOperators;
    private final List<ZenNativeOperator> binaryOperators;
    private final List<ZenNativeOperator> unaryOperators;

    public TypeExpansion(String type) {
        this.type = type;
        this.members = new HashMap<String, ZenExpandMember>();
        this.staticMembers = new HashMap<String, ZenExpandMember>();
        this.casters = new ArrayList<ZenExpandCaster>();
        this.trinaryOperators = new ArrayList<ZenNativeOperator>();
        this.binaryOperators = new ArrayList<ZenNativeOperator>();
        this.unaryOperators = new ArrayList<ZenNativeOperator>();
    }

    public void expand(Class cls, ITypeRegistry types) {
        for (Method method : cls.getMethods()) {
            String methodName = method.getName();
            for (Annotation annotation : method.getAnnotations()) {
                Annotation methodAnnotation;
                String name;
                if (annotation instanceof ZenCaster) {
                    this.checkStatic(method);
                    this.casters.add(new ZenExpandCaster(new JavaMethod(cls, method, types)));
                    continue;
                }
                if (annotation instanceof ZenGetter) {
                    this.checkStatic(method);
                    ZenGetter getterAnnotation = (ZenGetter)annotation;
                    String string = name = getterAnnotation.value().length() == 0 ? method.getName() : getterAnnotation.value();
                    if (!this.members.containsKey(name)) {
                        this.members.put(name, new ZenExpandMember(this.type, name));
                    }
                    this.members.get(name).setGetter(new JavaMethod(cls, method, types));
                    continue;
                }
                if (annotation instanceof ZenSetter) {
                    this.checkStatic(method);
                    ZenSetter setterAnnotation = (ZenSetter)annotation;
                    String string = name = setterAnnotation.value().length() == 0 ? method.getName() : setterAnnotation.value();
                    if (!this.members.containsKey(name)) {
                        this.members.put(name, new ZenExpandMember(this.type, name));
                    }
                    this.members.get(name).setSetter(new JavaMethod(cls, method, types));
                    continue;
                }
                if (annotation instanceof ZenOperator) {
                    this.checkStatic(method);
                    ZenOperator operatorAnnotation = (ZenOperator)annotation;
                    switch (operatorAnnotation.value()) {
                        case NEG: 
                        case NOT: {
                            if (method.getParameterTypes().length != 0) break;
                            this.unaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(cls, method, types)));
                            break;
                        }
                        case ADD: 
                        case SUB: 
                        case CAT: 
                        case MUL: 
                        case DIV: 
                        case MOD: 
                        case AND: 
                        case OR: 
                        case XOR: 
                        case INDEXGET: 
                        case RANGE: 
                        case CONTAINS: 
                        case COMPARE: {
                            if (method.getParameterTypes().length != 1) break;
                            this.binaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(cls, method, types)));
                            break;
                        }
                        case INDEXSET: {
                            if (method.getParameterTypes().length != 2) break;
                            this.trinaryOperators.add(new ZenNativeOperator(operatorAnnotation.value(), new JavaMethod(cls, method, types)));
                        }
                    }
                    continue;
                }
                if (annotation instanceof ZenMethod) {
                    this.checkStatic(method);
                    methodAnnotation = (ZenMethod)annotation;
                    if (methodAnnotation.value().length() > 0) {
                        methodName = methodAnnotation.value();
                    }
                    if (!this.members.containsKey(methodName)) {
                        this.members.put(methodName, new ZenExpandMember(this.type, methodName));
                    }
                    this.members.get(methodName).addMethod(new JavaMethod(cls, method, types));
                    continue;
                }
                if (!(annotation instanceof ZenMethodStatic)) continue;
                this.checkStatic(method);
                methodAnnotation = (ZenMethodStatic)annotation;
                if (methodAnnotation.value().length() > 0) {
                    methodName = methodAnnotation.value();
                }
                if (!this.staticMembers.containsKey(methodName)) {
                    this.staticMembers.put(methodName, new ZenExpandMember(this.type, methodName));
                }
                this.staticMembers.get(methodName).addMethod(new JavaMethod(cls, method, types));
            }
        }
    }

    public ZenExpandCaster getCaster(ZenType type, IEnvironmentGlobal environment) {
        for (ZenExpandCaster caster : this.casters) {
            if (!caster.getTarget().equals(type)) continue;
            return caster;
        }
        for (ZenExpandCaster caster : this.casters) {
            if (!caster.getTarget().canCastImplicit(type, environment)) continue;
            return caster;
        }
        return null;
    }

    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        for (ZenNativeOperator op : this.unaryOperators) {
            if (op.getOperator() != operator) continue;
            return op.getMethod().callStatic(position, environment, value);
        }
        return null;
    }

    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        for (ZenNativeOperator op : this.binaryOperators) {
            if (op.getOperator() != operator) continue;
            return op.getMethod().callStatic(position, environment, left, right);
        }
        return null;
    }

    public Expression ternary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        for (ZenNativeOperator op : this.trinaryOperators) {
            if (op.getOperator() != operator) continue;
            return op.getMethod().callStatic(position, environment, first, second, third);
        }
        return null;
    }

    public IPartialExpression instanceMember(ZenPosition position, IEnvironmentGlobal environment, Expression value, String member) {
        if (this.members.containsKey(member)) {
            return this.members.get(member).instance(position, environment, value);
        }
        return null;
    }

    public IPartialExpression staticMember(ZenPosition position, IEnvironmentGlobal environment, String member) {
        if (this.staticMembers.containsKey(member)) {
            return this.staticMembers.get(member).instance(position, environment);
        }
        return null;
    }

    private void checkStatic(Method method) {
        if ((method.getModifiers() & 8) == 0) {
            throw new RuntimeException("Expansion method " + method.getName() + " must be static");
        }
    }
}

