/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.parser;

import stanhebben.zenscript.ZenParsedFile;
import stanhebben.zenscript.parser.Token;

public class ParseException
extends RuntimeException {
    private final ZenParsedFile file;
    private final int line;
    private final int lineOffset;
    private final Token token;
    private final String message;

    public ParseException(Token token, String error) {
        super(token == null ? "Error at end of file - " + error : "Error parsing line " + token.getPosition().getLine() + ":" + token.getPosition().getLineOffset() + " - " + error + " (last token: " + token.getValue() + ")");
        this.file = token.getPosition().getFile();
        this.line = token.getPosition().getLine();
        this.lineOffset = token.getPosition().getLineOffset();
        this.token = token;
        this.message = error;
    }

    public ParseException(ZenParsedFile file, int line, int lineOffset, String error) {
        this.file = file;
        this.line = line;
        this.lineOffset = lineOffset;
        this.token = null;
        this.message = error;
    }

    public ZenParsedFile getFile() {
        return this.file;
    }

    public int getLine() {
        return this.token == null ? -1 : this.token.getPosition().getLine();
    }

    public int getLineOffset() {
        return this.token == null ? -1 : this.token.getPosition().getLineOffset();
    }

    public String getExplanation() {
        return this.message;
    }
}

