/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;
import stanhebben.zenscript.annotations.CompareType;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionAs;
import stanhebben.zenscript.expression.ExpressionCompareGeneric;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.type.IZenIterator;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.MethodCompiler;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;
import stanhebben.zenscript.util.ZenTypeUtil;
import stanhebben.zenscript.value.IAny;

public class ZenTypeAny
extends ZenType {
    public static final ZenTypeAny INSTANCE = new ZenTypeAny();
    private static final Map<String, MethodCompiler> CASTERS = new HashMap<String, MethodCompiler>();

    private ZenTypeAny() {
    }

    @Override
    public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value, String name) {
        environment.error(position, "any values not yet supported");
        return new ExpressionInvalid(position);
    }

    @Override
    public IPartialExpression getStaticMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
        environment.error(position, "any values not yet supported");
        return new ExpressionInvalid(position);
    }

    @Override
    public IZenIterator makeIterator(int numValues, IEnvironmentMethod methodOutput) {
        return null;
    }

    @Override
    public boolean canCastImplicit(ZenType type, IEnvironmentGlobal environment) {
        return true;
    }

    @Override
    public boolean canCastExplicit(ZenType type, IEnvironmentGlobal environment) {
        return true;
    }

    @Override
    public Class toJavaClass() {
        return IAny.class;
    }

    @Override
    public Type toASMType() {
        return Type.getType(IAny.class);
    }

    @Override
    public int getNumberType() {
        return 0;
    }

    @Override
    public String getSignature() {
        return ZenTypeUtil.signature(IAny.class);
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    @Override
    public void compileCast(ZenPosition position, IEnvironmentMethod environment, ZenType toType) {
        if (CASTERS.containsKey(toType.getName())) {
            CASTERS.get(toType.getName()).compile(environment.getOutput());
        } else if (!this.compileCastExpansion(position, environment, toType)) {
            environment.getOutput().constant(toType);
            environment.getOutput().invokeInterface(IAny.class, "as", Class.class, Object.class);
        }
    }

    @Override
    public Expression unary(ZenPosition position, IEnvironmentGlobal environment, Expression value, OperatorType operator) {
        switch (operator) {
            default: 
        }
        return new ExpressionInvalid(position, INSTANCE);
    }

    @Override
    public Expression binary(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, OperatorType operator) {
        switch (operator) {
            default: 
        }
        return new ExpressionInvalid(position, ANY);
    }

    @Override
    public Expression trinary(ZenPosition position, IEnvironmentGlobal environment, Expression first, Expression second, Expression third, OperatorType operator) {
        switch (operator) {
            default: 
        }
        return new ExpressionInvalid(position, ANY);
    }

    @Override
    public Expression compare(ZenPosition position, IEnvironmentGlobal environment, Expression left, Expression right, CompareType type) {
        Expression comparator = JavaMethod.get(environment, IAny.class, "compareTo", IAny.class).callVirtual(position, environment, left, right);
        return new ExpressionCompareGeneric(position, comparator, type);
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        return JavaMethod.get(environment, IAny.class, "call", IAny[].class).callVirtual(position, environment, receiver, arguments);
    }

    @Override
    public Expression cast(ZenPosition position, IEnvironmentGlobal environment, Expression value, ZenType type) {
        if (type.equals(this)) {
            return value;
        }
        if (this.canCastExpansion(environment, type)) {
            return this.castExpansion(position, environment, value, type);
        }
        return new ExpressionAs(position, value, type);
    }

    @Override
    public String getName() {
        return "any";
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    static {
        CASTERS.put("bool", new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asBool", Boolean.TYPE, new Class[0]);
            }
        });
        CASTERS.put("byte", new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asByte", Byte.TYPE, new Class[0]);
            }
        });
        CASTERS.put("short", new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asShort", Short.TYPE, new Class[0]);
            }
        });
        CASTERS.put("int", new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asInt", Integer.TYPE, new Class[0]);
            }
        });
        CASTERS.put("long", new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asLong", Long.TYPE, new Class[0]);
            }
        });
        CASTERS.put("float", new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asFloat", Float.TYPE, new Class[0]);
            }
        });
        CASTERS.put("double", new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asDouble", Double.TYPE, new Class[0]);
            }
        });
        CASTERS.put(Boolean.class.getName(), new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asBool", Boolean.TYPE, new Class[0]);
                output.invokeStatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
            }
        });
        CASTERS.put(Byte.class.getName(), new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asByte", Boolean.TYPE, new Class[0]);
                output.invokeStatic(Byte.class, "valueOf", Byte.class, Byte.TYPE);
            }
        });
        CASTERS.put(Short.class.getName(), new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asShort", Short.TYPE, new Class[0]);
                output.invokeStatic(Short.class, "valueOf", Short.class, Short.TYPE);
            }
        });
        CASTERS.put(Integer.class.getName(), new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asInt", Integer.TYPE, new Class[0]);
                output.invokeStatic(Integer.class, "valueOf", Integer.class, Integer.TYPE);
            }
        });
        CASTERS.put(Long.class.getName(), new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asLong", Long.TYPE, new Class[0]);
                output.invokeStatic(Long.class, "valueOf", Long.class, Long.TYPE);
            }
        });
        CASTERS.put(Float.class.getName(), new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asFloat", Float.TYPE, new Class[0]);
                output.invokeStatic(Float.class, "valueOf", Float.class, Float.TYPE);
            }
        });
        CASTERS.put(Double.class.getName(), new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asDouble", Double.TYPE, new Class[0]);
                output.invokeStatic(Double.class, "valueOf", Double.class, Double.TYPE);
            }
        });
        CASTERS.put(String.class.getName(), new MethodCompiler(){

            @Override
            public void compile(MethodOutput output) {
                output.invokeInterface(IAny.class, "asString", String.class, new Class[0]);
            }
        });
    }
}

